/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.nuxeo.build.swing.ArtifactTableModel;
import org.nuxeo.build.swing.CompositeFilter;
import org.nuxeo.build.swing.Filter;
import org.nuxeo.build.swing.IconUtils;
import org.nuxeo.build.swing.MultiExclusionFilter;
import org.nuxeo.build.swing.MultiPrefixFilter;
import org.nuxeo.build.swing.PrefixFilter;
import org.nuxeo.build.swing.ProfilesDialog;

public class ArtifactTable
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected JFrame frame;
    protected boolean isDirty;
    protected JToolBar tbar;
    protected JTable table;
    JTextField textFilter;
    JToggleButton btnFilter;
    protected ArtifactTableModel model;
    protected File file;

    public ArtifactTable(JFrame frame) {
        super(new BorderLayout(5, 5));
        this.frame = frame;
        this.tbar = new JToolBar();
        AbstractAction action = new AbstractAction("Add", IconUtils.createImageIcon(this.getClass(), "add.gif")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ArtifactTable.this.openAddArtifactDialog();
            }
        };
        action.putValue("ShortDescription", "Add Artifact");
        this.tbar.add(action);
        action = new AbstractAction("Remove", IconUtils.createImageIcon(this.getClass(), "delete.gif")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ArtifactTable.this.deleteSelectedArtifacts();
            }
        };
        action.putValue("ShortDescription", "Remove Selected Artifacts");
        this.tbar.add(action);
        action = new AbstractAction("Profiles", IconUtils.createImageIcon(this.getClass(), "profiles.gif")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ArtifactTable.this.openProfilesDialog();
            }
        };
        action.putValue("ShortDescription", "Manage Profiles");
        this.tbar.add(action);
        JComboBox<String> presets = new JComboBox<String>(new String[]{"All", "Runtime", "Core", "Features", "Toolkits", "Libraries"});
        presets.setToolTipText("Default Filters");
        presets.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String preset = (String)((JComboBox)e.getSource()).getSelectedItem();
                System.out.println("preset: " + preset);
                if ("All".equals(preset)) {
                    ArtifactTable.this.removePresetFilter();
                } else if ("Runtime".equals(preset)) {
                    ArtifactTable.this.applyPresetFilter(new MultiPrefixFilter("nuxeo-runtime", "org.nuxeo.runtime", "nuxeo-common", "org.nuxeo.common"));
                } else if ("Core".equals(preset)) {
                    ArtifactTable.this.applyPresetFilter(new MultiPrefixFilter("nuxeo-core", "org.nuxeo.ecm.core"));
                } else if ("Features".equals(preset)) {
                    ArtifactTable.this.applyPresetFilter(new MultiPrefixFilter("nuxeo-platform", "org.nuxeo.ecm.platform"));
                } else if ("Toolkits".equals(preset)) {
                    ArtifactTable.this.applyPresetFilter(new MultiPrefixFilter("nuxeo-webengine", "org.nuxeo.ecm.webengine", "nuxeo-theme", "org.nuxeo.theme"));
                } else if ("Libraries".equals(preset)) {
                    ArtifactTable.this.applyPresetFilter(new MultiExclusionFilter("nuxeo-", "org.nuxeo"));
                }
            }
        });
        this.tbar.add(presets);
        this.textFilter = new JTextField();
        this.tbar.add(this.textFilter);
        this.btnFilter = new JToggleButton(null, IconUtils.createImageIcon(this.getClass(), "search.gif"));
        this.btnFilter.setSelected(false);
        this.btnFilter.setToolTipText("Apply Filter");
        this.tbar.add(this.btnFilter);
        this.textFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!ArtifactTable.this.btnFilter.isSelected()) {
                    ArtifactTable.this.btnFilter.doClick();
                } else {
                    String text = ArtifactTable.this.textFilter.getText().trim();
                    if (text.length() > 0) {
                        ArtifactTable.this.applyPrefixFilter(text);
                    }
                }
            }
        });
        this.btnFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ArtifactTable.this.togglePrefixFilter();
            }
        });
        this.add((Component)this.tbar, "First");
        this.model = new ArtifactTableModel(this);
        this.table = new JTable(this.model);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add((Component)scrollPane, "Center");
        this.installKeybordShortcuts();
    }

    public void applyPrefixFilter(String prefix) {
        PrefixFilter filter = new PrefixFilter(prefix);
        CompositeFilter cf = (CompositeFilter)this.model.getFilter();
        if (cf != null) {
            cf.setPrefixFilter(filter);
            this.model.buildRows();
        } else {
            cf = new CompositeFilter();
            cf.setPrefixFilter(filter);
            this.model.setFilter(cf);
        }
    }

    public void removePrefixFilter() {
        CompositeFilter cf = (CompositeFilter)this.model.getFilter();
        if (cf != null) {
            cf.setPrefixFilter(null);
            this.model.buildRows();
        }
    }

    public void applyPresetFilter(Filter filter) {
        CompositeFilter cf = (CompositeFilter)this.model.getFilter();
        if (cf != null) {
            cf.setPresetFilter(filter);
            this.model.buildRows();
        } else {
            cf = new CompositeFilter();
            cf.setPresetFilter(filter);
            this.model.setFilter(cf);
        }
    }

    public void removePresetFilter() {
        CompositeFilter cf = (CompositeFilter)this.model.getFilter();
        if (cf != null) {
            cf.setPresetFilter(null);
            this.model.buildRows();
        }
    }

    public void removeFilters() {
        this.model.setFilter(null);
    }

    public void setDirty(boolean value) {
        this.isDirty = value;
        if (this.isDirty) {
            this.frame.setTitle("* Assembly Editor - " + (this.file == null ? "Untitled" : this.file.getName()));
        } else {
            this.frame.setTitle("Assembly Editor - " + (this.file == null ? "Untitled" : this.file.getName()));
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void loadFile(File file) throws IOException {
        this.model.load(file);
        this.file = file;
        this.setDirty(false);
    }

    protected boolean selectFile(boolean save) {
        JFileChooser fc = new JFileChooser();
        int r = 0;
        r = save ? fc.showSaveDialog(this) : fc.showOpenDialog(this);
        if (r == 0) {
            this.file = fc.getSelectedFile();
            return true;
        }
        return false;
    }

    public void open() throws IOException {
        if (this.selectFile(false)) {
            this.model.load(this.file);
            this.setDirty(false);
        }
    }

    public void save() throws IOException {
        if (this.file == null) {
            if (this.selectFile(true)) {
                this.model.store(this.file);
            }
        } else {
            this.model.store(this.file);
        }
        this.setDirty(false);
    }

    public void saveAs(File file) throws IOException {
        this.model.store(file);
    }

    public ArtifactTableModel getModel() {
        return this.model;
    }

    public void openProfilesDialog() {
        ProfilesDialog dlg = new ProfilesDialog(null, this);
        dlg.pack();
        dlg.setSize(400, 400);
        dlg.setLocationRelativeTo(this);
        dlg.setVisible(true);
    }

    public void openAddArtifactDialog() {
        String s = JOptionPane.showInputDialog(this, "Artifact Key: ", "Add Artifact", -1);
        if (s != null) {
            ArtifactTableModel.ArtifactRow row = new ArtifactTableModel.ArtifactRow(s);
            this.model.map.put(s, row);
            this.model.getVisibleRows().add(row);
            this.model.fireTableDataChanged();
            this.setDirty(true);
        }
    }

    public void deleteSelectedArtifacts() {
        int i;
        int[] rows = this.table.getSelectedRows();
        ArtifactTableModel.ArtifactRow[] _rows = new ArtifactTableModel.ArtifactRow[rows.length];
        for (i = 0; i < rows.length; ++i) {
            _rows[i] = this.model.getVisibleRows().get(rows[i]);
        }
        for (i = 0; i < rows.length; ++i) {
            this.model.getVisibleRows().remove(_rows[i]);
            this.model.map.remove(_rows[i].key);
            this.setDirty(true);
        }
        this.model.fireTableDataChanged();
    }

    public void togglePrefixFilter() {
        if (this.btnFilter.isSelected()) {
            String text = this.textFilter.getText().trim();
            if (text.length() > 0) {
                this.applyPrefixFilter(text);
            }
        } else {
            this.removePrefixFilter();
        }
    }

    public void installKeybordShortcuts() {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ArtifactTable.this.btnFilter.isSelected()) {
                    ArtifactTable.this.btnFilter.doClick();
                }
            }
        }, stroke, 2);
    }
}

