/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dev;

import java.lang.reflect.Method;
import java.net.URL;
import org.nuxeo.osgi.application.MutableClassLoader;

public class ClassLoaderDelegate
implements MutableClassLoader {
    protected ClassLoader cl;
    protected Method addURL;
    protected Method getURLs;

    public ClassLoaderDelegate(ClassLoader cl) throws IllegalArgumentException {
        this.initialize(cl);
        if (this.addURL == null) {
            throw new IllegalArgumentException("Incompatible class loader: " + cl.getClass() + ". ClassLoader must provide a method: addURL(URL url)");
        }
        this.addURL.setAccessible(true);
        this.getURLs.setAccessible(true);
    }

    protected void initialize(ClassLoader cl) {
        Class<?> clazz = cl.getClass();
        do {
            try {
                if (this.addURL == null) {
                    this.addURL = clazz.getDeclaredMethod("addURL", URL.class);
                }
                if (this.getURLs != null) continue;
                this.getURLs = clazz.getDeclaredMethod("getURLs", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                clazz = clazz.getSuperclass();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to adapt class loader: " + cl.getClass(), e);
            }
        } while ((this.addURL == null || this.getURLs == null) && clazz != null);
        if (this.addURL == null) {
            ClassLoader parent = cl.getParent();
            if (parent != null) {
                this.initialize(parent);
            }
        } else {
            this.cl = cl;
        }
    }

    public void addURL(URL url) {
        try {
            this.addURL.invoke((Object)this.cl, url);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add URL to class loader: " + url, e);
        }
    }

    public URL[] getURLs() {
        try {
            return (URL[])this.getURLs.invoke((Object)this.cl, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get URLs from class loader", e);
        }
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }
}

