/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dev;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class ConfigurationReader {
    protected SectionReader defaultReader = new NullReader();
    protected Map<String, SectionReader> readers = new HashMap<String, SectionReader>();

    public void setDefaultReader(SectionReader reader) {
        this.defaultReader = reader;
    }

    public void addReader(String section, SectionReader reader) {
        this.readers.put(section, reader);
        if (section.length() == 0) {
            this.defaultReader = reader;
        }
    }

    public SectionReader getDefaultReader() {
        return this.defaultReader;
    }

    public SectionReader getReader(String section) {
        SectionReader reader = this.readers.get(section);
        return reader == null ? this.defaultReader : reader;
    }

    public void read(InputStream in) throws IOException {
        this.read(new BufferedReader(new InputStreamReader(in)));
    }

    public void read(BufferedReader reader) throws IOException {
        SectionReader creader = this.defaultReader;
        String section = "";
        String line = reader.readLine();
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) {
                line = reader.readLine();
                continue;
            }
            if (line.startsWith("[") && line.endsWith("]")) {
                section = line.substring(1, line.length() - 1);
                creader = this.getReader(section);
                line = reader.readLine();
                continue;
            }
            creader.readLine(section, line);
            line = reader.readLine();
        }
    }

    protected static class NullReader
    implements SectionReader {
        protected NullReader() {
        }

        public void readLine(String section, String line) throws IOException {
        }
    }

    public static interface SectionReader {
        public void readLine(String var1, String var2) throws IOException;
    }
}

