/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dev;

import java.net.URL;
import java.net.URLClassLoader;
import org.nuxeo.dev.NuxeoApp;
import org.nuxeo.osgi.application.MutableClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsolatedClassLoader
extends URLClassLoader
implements MutableClassLoader {
    public IsolatedClassLoader() {
        super(new URL[0], NuxeoApp.findContextClassLoader());
    }

    public IsolatedClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    public IsolatedClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.preFind(name);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                if (c == null) {
                    c = this.postFind(name);
                }
            }
        }
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    protected Class<?> loadFromParent(String name) throws ClassNotFoundException {
        if (this.getParent() != null) {
            return this.getParent().loadClass(name);
        }
        return null;
    }

    protected Class<?> preFind(String name) throws ClassNotFoundException {
        if (name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("org.w3c.")) {
            return this.loadFromParent(name);
        }
        return null;
    }

    protected Class<?> postFind(String name) throws ClassNotFoundException {
        return this.loadFromParent(name);
    }

    private void printDebug(Class<?> c, String cname) {
        this.printDebug(c, cname, "### FOUND: ");
    }

    private void printDebug(Class<?> c, String cname, String msg) {
        if (c == null) {
            return;
        }
        if (c.getName().equals(cname)) {
            System.out.println(msg + cname + "; CL: " + c.getClassLoader() + " : " + System.identityHashCode(c.getClassLoader()) + "; LOCATION: " + c.getProtectionDomain().getCodeSource().getLocation());
        }
    }
}

