/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.api.objects.task;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.client.api.NuxeoClient;
import org.nuxeo.client.api.methods.TaskManagerAPI;
import org.nuxeo.client.api.objects.NuxeoEntity;
import org.nuxeo.client.api.objects.task.Task;
import org.nuxeo.client.api.objects.task.TaskCompletionRequest;
import org.nuxeo.client.api.objects.task.Tasks;

public class TaskManager
extends NuxeoEntity {
    public TaskManager(NuxeoClient nuxeoClient) {
        super(null, nuxeoClient, TaskManagerAPI.class);
    }

    public Tasks fetchTasks(String userId, String workflowInstanceId, String workflowModelName) {
        return (Tasks)this.getResponse(userId, workflowInstanceId, workflowModelName);
    }

    public Task fetchTask(String taskId) {
        return (Task)this.getResponse(taskId);
    }

    public Task reassign(String taskId, List<String> actors, String comment) {
        String actorsValue = StringUtils.join(actors, (String)",");
        return this.reassign(taskId, actorsValue, comment);
    }

    public Task reassign(String taskId, String actors, String comment) {
        return (Task)this.getResponse(taskId, actors, comment);
    }

    public Task delegate(String taskId, List<String> actors, String comment) {
        String actorsValue = StringUtils.join(actors, (String)",");
        return this.reassign(taskId, actorsValue, comment);
    }

    public Task delegate(String taskId, String actors, String comment) {
        return (Task)this.getResponse(taskId, actors, comment);
    }

    public Task complete(String taskId, String action, TaskCompletionRequest taskCompletionRequest) {
        return (Task)this.getResponse(taskId, action, taskCompletionRequest);
    }
}

