/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.api.marshaller;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.nuxeo.client.api.marshaller.NuxeoMarshaller;
import org.nuxeo.client.api.marshaller.NuxeoRequestConverterFactory;
import org.nuxeo.client.api.marshaller.NuxeoResponseConverterFactory;
import org.nuxeo.client.internals.spi.NuxeoClientException;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class NuxeoConverterFactory
extends Converter.Factory {
    protected static final Map<Class<?>, NuxeoMarshaller<?>> marshallers = new ConcurrentHashMap();
    protected final ObjectMapper mapper;

    public static NuxeoConverterFactory create() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return NuxeoConverterFactory.create(objectMapper);
    }

    public static NuxeoConverterFactory create(ObjectMapper mapper) {
        return new NuxeoConverterFactory(mapper);
    }

    protected NuxeoConverterFactory(ObjectMapper mapper) {
        if (mapper == null) {
            throw new NullPointerException("mapper == null");
        }
        this.mapper = mapper;
    }

    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit client) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        NuxeoMarshaller<?> nuxeoMarshaller = marshallers.get(javaType.getRawClass());
        if (nuxeoMarshaller != null) {
            return new NuxeoResponseConverterFactory(nuxeoMarshaller, this.mapper);
        }
        ObjectReader reader = this.mapper.readerFor(javaType);
        return new NuxeoResponseConverterFactory(reader, this.mapper, javaType);
    }

    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        NuxeoMarshaller<?> nuxeoMarshaller = marshallers.get(javaType.getRawClass());
        if (nuxeoMarshaller != null) {
            return new NuxeoRequestConverterFactory(nuxeoMarshaller, this.mapper);
        }
        ObjectWriter writer = this.mapper.writerFor(javaType);
        return new NuxeoRequestConverterFactory(writer, this.mapper, javaType);
    }

    public void registerMarshaller(NuxeoMarshaller<?> marshaller) {
        marshallers.put(marshaller.getJavaType(), marshaller);
    }

    public void clearMarshaller() {
        marshallers.clear();
    }

    public <T> T readJSON(String json, Class javaType) {
        try {
            return (T)this.mapper.readValue(json, javaType);
        }
        catch (IOException reason) {
            throw new NuxeoClientException("Converter Read Issue. See NuxeoConverterFactory#readJSON", reason);
        }
    }

    public String writeJSON(Object object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (IOException reason) {
            throw new NuxeoClientException("Converter Write Issue. See NuxeoConverterFactory#writeJSON", reason);
        }
    }
}

