/*
 * (C) Copyright 2017 Nuxeo (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     Kevin Leturc <kleturc@nuxeo.com>
 */
package org.nuxeo.client.objects.blob;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

/**
 * @since 3.0
 */
public interface Blob extends Serializable {

    String getFilename();

    String getMimeType();

    /**
     * @deprecated since 3.1, use {@link #getContentLength()} instead
     */
    @Deprecated
    int getLength();

    /**
     * @since 3.1
     */
    long getContentLength();

    InputStream getStream() throws IOException;

}
