/*
 * (C) Copyright 2016-2017 Nuxeo (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     Vladimir Pasquier <vpasquier@nuxeo.com>
 *     Kevin Leturc <kleturc@nuxeo.com>
 */
package org.nuxeo.client.objects.task;

import java.io.Serializable;
import java.util.Calendar;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @since 1.0
 */
public class TaskVariables implements Serializable {

    protected String comment;

    protected List<String> assignees; // NOSONAR

    @JsonProperty("end_date")
    protected Calendar endDate;

    protected List<String> participants; // NOSONAR

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<String> getAssignees() {
        return assignees;
    }

    public void setAssignees(List<String> assignees) {
        this.assignees = assignees;
    }

    /**
     * @deprecated since 3.2, use {@link #getEndDate()} instead
     */
    @Deprecated
    @JsonIgnore
    public Calendar getEnd_date() { // NOSONAR
        return getEndDate();
    }

    public Calendar getEndDate() {
        return endDate;
    }

    /**
     * @deprecated since 3.2, use {@link #setEndDate(Calendar)} instead
     */
    @Deprecated
    @JsonIgnore
    public void setEnd_date(Calendar endDate) { // NOSONAR
        setEndDate(endDate);
    }

    public void setEndDate(Calendar endDate) {
        this.endDate = endDate;
    }

    public List<String> getParticipants() {
        return participants;
    }

    public void setParticipants(List<String> participants) {
        this.participants = participants;
    }

}
