/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client;

import java.nio.charset.Charset;
import java.util.Locale;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class MediaType {
    private static final String TOKEN = "([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)";
    private static final String QUOTED = "\"([^\"]*)\"";
    private static final Pattern TYPE_SUBTYPE = Pattern.compile("([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)/([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)");
    private static final Pattern PARAMETER = Pattern.compile(";\\s*(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)=(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)|\"([^\"]*)\"))?");
    protected static final String DEFAULT_STRING = "application/octet-stream";
    protected static final MediaType DEFAULT = MediaType.parse("application/octet-stream");
    private final String originalString;
    private final String type;
    private final String subtype;
    private final String charset;
    private final String nuxeoEntity;

    private MediaType(String originalString, String type, String subtype, String charset, String nuxeoEntity) {
        this.originalString = originalString;
        this.type = type;
        this.subtype = subtype;
        this.charset = charset;
        this.nuxeoEntity = nuxeoEntity;
    }

    public String type() {
        return this.type;
    }

    public String subtype() {
        return this.subtype;
    }

    public Charset charset() {
        return this.charset != null ? Charset.forName(this.charset) : null;
    }

    public String nuxeoEntity() {
        return this.nuxeoEntity;
    }

    public Charset charset(Charset defaultValue) {
        return this.charset != null ? Charset.forName(this.charset) : defaultValue;
    }

    public okhttp3.MediaType toOkHttpMediaType() {
        return okhttp3.MediaType.parse((String)this.originalString);
    }

    public boolean equalsType(MediaType mediaType) {
        return mediaType != null && StringUtils.equals((CharSequence)this.type, (CharSequence)mediaType.type);
    }

    public boolean equalsTypeSubType(MediaType mediaType) {
        return this.equalsType(mediaType) && StringUtils.equals((CharSequence)this.subtype, (CharSequence)mediaType.subtype);
    }

    public boolean equalsTypeSubTypeWithoutSuffix(MediaType mediaType) {
        if (this.equalsType(mediaType)) {
            UnaryOperator removeSuffix = s -> s.replaceAll("\\+.*", "");
            String thisSubtype = (String)removeSuffix.apply(this.subtype);
            String givenSubtype = (String)removeSuffix.apply(mediaType.subtype);
            return thisSubtype.equals(givenSubtype);
        }
        return false;
    }

    public String toString() {
        return this.originalString;
    }

    public boolean equals(Object o) {
        return o instanceof MediaType && ((MediaType)o).originalString.equals(this.originalString);
    }

    public int hashCode() {
        return this.originalString.hashCode();
    }

    public static MediaType fromOkHttpMediaType(okhttp3.MediaType mediaType) {
        if (mediaType == null) {
            return DEFAULT;
        }
        return MediaType.parse(mediaType.toString());
    }

    public static MediaType parse(String string) {
        Matcher typeSubtype = TYPE_SUBTYPE.matcher(string);
        if (!typeSubtype.lookingAt()) {
            return DEFAULT;
        }
        String type = typeSubtype.group(1).toLowerCase(Locale.US);
        String subtype = typeSubtype.group(2).toLowerCase(Locale.US);
        String charset = null;
        String nuxeoEntity = null;
        Matcher parameter = PARAMETER.matcher(string);
        int s = typeSubtype.end();
        while (s < string.length()) {
            String name;
            parameter.region(s, string.length());
            if (parameter.lookingAt() && (name = parameter.group(1)) != null) {
                String charsetParameter;
                if (name.equalsIgnoreCase("nuxeo-entity")) {
                    String nuxeoEntityParameter;
                    String string2 = nuxeoEntityParameter = parameter.group(2) != null ? parameter.group(2) : parameter.group(3);
                    if (nuxeoEntity != null && !nuxeoEntityParameter.equalsIgnoreCase(nuxeoEntity)) {
                        throw new IllegalArgumentException("Multiple different nuxeo entities: " + string);
                    }
                    nuxeoEntity = nuxeoEntityParameter;
                }
                String string3 = charsetParameter = parameter.group(2) != null ? parameter.group(2) : parameter.group(3);
                if (charset != null && !charsetParameter.equalsIgnoreCase(charset)) {
                    throw new IllegalArgumentException("Multiple different charsets: " + string);
                }
                charset = charsetParameter;
            }
            s = parameter.end();
        }
        return new MediaType(string, type, subtype, charset, nuxeoEntity);
    }
}

