/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Properties;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Version;
import org.nuxeo.client.MediaType;
import org.nuxeo.client.MediaTypes;
import org.nuxeo.client.NuxeoVersion;
import org.nuxeo.client.cache.NuxeoResponseCache;
import org.nuxeo.client.marshaller.NuxeoConverterFactory;
import org.nuxeo.client.objects.AbstractBase;
import org.nuxeo.client.objects.Connectable;
import org.nuxeo.client.objects.Document;
import org.nuxeo.client.objects.Documents;
import org.nuxeo.client.objects.Operation;
import org.nuxeo.client.objects.RecordSet;
import org.nuxeo.client.objects.Repository;
import org.nuxeo.client.objects.blob.Blob;
import org.nuxeo.client.objects.blob.Blobs;
import org.nuxeo.client.objects.blob.FileBlob;
import org.nuxeo.client.objects.blob.FileStreamBlob;
import org.nuxeo.client.objects.blob.StreamBlob;
import org.nuxeo.client.objects.comment.Annotation;
import org.nuxeo.client.objects.comment.Annotations;
import org.nuxeo.client.objects.comment.Comment;
import org.nuxeo.client.objects.comment.Comments;
import org.nuxeo.client.objects.config.ConfigManager;
import org.nuxeo.client.objects.directory.DirectoryManager;
import org.nuxeo.client.objects.task.Task;
import org.nuxeo.client.objects.task.TaskManager;
import org.nuxeo.client.objects.task.Tasks;
import org.nuxeo.client.objects.upload.BatchUploadManager;
import org.nuxeo.client.objects.user.User;
import org.nuxeo.client.objects.user.UserManager;
import org.nuxeo.client.spi.NuxeoClientException;
import org.nuxeo.client.spi.NuxeoClientRemoteException;
import org.nuxeo.client.spi.auth.BasicAuthInterceptor;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;

public class NuxeoClient
extends AbstractBase<NuxeoClient> {
    public static final Pattern CMIS_PRODUCT_VERSION_PATTERN = Pattern.compile("\"productVersion\":\"(.*?)\"");
    protected final NuxeoConverterFactory converterFactory;
    protected NuxeoResponseCache nuxeoCache;
    protected User currentUser;
    protected NuxeoVersion serverVersion;

    protected NuxeoClient(Builder builder) {
        super(builder);
        this.converterFactory = builder.converterFactory;
        this.nuxeoCache = builder.cache;
        this.header("User-Agent", this.computeUserAgent(), new String[0]);
    }

    protected void addOkHttpInterceptor(Interceptor interceptor) {
        this.okhttpBuilder.addInterceptor(interceptor);
        this.buildRetrofit();
    }

    protected String computeUserAgent() {
        String nuxeoPart = " NuxeoJavaClient/";
        try (InputStream inputStream = this.getClass().getResourceAsStream("/META-INF/nuxeo-java-client.properties");){
            Properties properties = new Properties();
            properties.load(inputStream);
            String nuxeoVersion = properties.getProperty("nuxeo.java.client.version");
            nuxeoPart = nuxeoPart + nuxeoVersion;
        }
        catch (IOException e) {
            nuxeoPart = nuxeoPart + "Unknown";
        }
        return Version.userAgent() + nuxeoPart;
    }

    public NuxeoConverterFactory getConverterFactory() {
        return this.converterFactory;
    }

    public NuxeoResponseCache getNuxeoCache() {
        return this.nuxeoCache;
    }

    public boolean isCacheEnabled() {
        return this.nuxeoCache != null;
    }

    public NuxeoClient refreshCache() {
        if (this.isCacheEnabled()) {
            this.nuxeoCache.invalidateAll();
        }
        return this;
    }

    public void disconnect() {
        this.okhttpBuilder.interceptors().clear();
        this.headerInterceptors.clear();
        this.headerValues.clear();
        this.nuxeoCache = null;
        this.buildRetrofit();
    }

    public User getCurrentUser() {
        return this.currentUser;
    }

    public NuxeoVersion getServerVersion() {
        if (this.serverVersion == null) {
            try {
                Response response = this.get(this.retrofit.baseUrl().toString().replaceFirst("/api/v1/", "") + "/json/cmis");
                String body = response.body().string();
                Matcher matcher = CMIS_PRODUCT_VERSION_PATTERN.matcher(body);
                if (!matcher.find()) {
                    throw new NuxeoClientException("Unable to get version from CMIS");
                }
                String version = matcher.group(1);
                this.serverVersion = NuxeoVersion.parse(version);
            }
            catch (IOException ioe) {
                throw new NuxeoClientException("Unable to retrieve the server version.", ioe);
            }
        }
        return this.serverVersion;
    }

    public Repository repository() {
        return new Repository(this);
    }

    public Repository repository(String repositoryName) {
        return new Repository(this, repositoryName);
    }

    public Operation operation(String operationId) {
        return new Operation(this, operationId);
    }

    public UserManager userManager() {
        return new UserManager(this);
    }

    public DirectoryManager directoryManager() {
        return new DirectoryManager(this);
    }

    public TaskManager taskManager() {
        return new TaskManager(this);
    }

    public BatchUploadManager batchUploadManager() {
        return new BatchUploadManager(this);
    }

    public ConfigManager configManager() {
        return new ConfigManager(this);
    }

    public Response get(String url) {
        return this.request(url, Request.Builder::get);
    }

    public Response delete(String url) {
        return this.request(url, Request.Builder::delete);
    }

    public Response delete(String url, String json) {
        RequestBody body = RequestBody.create((okhttp3.MediaType)MediaTypes.APPLICATION_JSON_CHARSET_UTF_8.toOkHttpMediaType(), (String)json);
        return this.request(url, builder -> builder.delete(body));
    }

    public Response put(String url, String json) {
        RequestBody body = RequestBody.create((okhttp3.MediaType)MediaTypes.APPLICATION_JSON_CHARSET_UTF_8.toOkHttpMediaType(), (String)json);
        return this.request(url, builder -> builder.put(body));
    }

    public Response post(String url, String json) {
        RequestBody body = RequestBody.create((okhttp3.MediaType)MediaTypes.APPLICATION_JSON_CHARSET_UTF_8.toOkHttpMediaType(), (String)json);
        return this.request(url, builder -> builder.post(body));
    }

    protected Response request(String url, UnaryOperator<Request.Builder> method) {
        try {
            Request.Builder requestBuilder = new Request.Builder().url(url);
            Request request = ((Request.Builder)method.apply(requestBuilder)).build();
            return this.retrofit.callFactory().newCall(request).execute();
        }
        catch (IOException e) {
            throw new NuxeoClientException("Error during call on url=" + url, e);
        }
    }

    public <T> T fetchResponse(Call<T> call) {
        String cacheKey;
        Object result;
        if (this.useCache(call) && (result = this.nuxeoCache.getBody(cacheKey = this.computeCacheKey(call))) != null) {
            return result;
        }
        try {
            retrofit2.Response<T> response = call.execute();
            response = this.handleResponse(call, response);
            return (T)response.body();
        }
        catch (IOException reason) {
            throw new NuxeoClientException("Error during call on Nuxeo server", reason);
        }
    }

    public <T> void fetchResponse(Call<T> call, final Callback<T> callback) {
        call.enqueue(new Callback<T>(){

            public void onResponse(Call<T> call, retrofit2.Response<T> response) {
                try {
                    callback.onResponse(call, NuxeoClient.this.handleResponse(call, response));
                }
                catch (NuxeoClientException nce) {
                    callback.onFailure(call, (Throwable)nce);
                }
            }

            public void onFailure(Call<T> call, Throwable t) {
                callback.onFailure(call, t);
            }
        });
    }

    protected <T> retrofit2.Response<T> handleResponse(Call<T> call, retrofit2.Response<T> response) {
        try {
            int httpCode = response.code();
            String httpMessage = response.message();
            if (!response.isSuccessful() && httpCode != 308) {
                String errorBody = response.errorBody().string();
                MediaType mediaType = MediaType.fromOkHttpMediaType(response.raw().body().contentType());
                if (!"".equals(errorBody) && MediaTypes.APPLICATION_JSON.equalsTypeSubTypeWithoutSuffix(mediaType)) {
                    throw this.converterFactory.readJSON(errorBody, NuxeoClientRemoteException.class);
                }
                throw new NuxeoClientRemoteException(httpCode, httpMessage, errorBody, null);
            }
            if (this.useCache(call)) {
                this.nuxeoCache.put(this.computeCacheKey(call), response);
            }
            Object body = response.body();
            Headers headers = response.headers();
            if (body instanceof ResponseBody) {
                throw new NuxeoClientException("Internal client error, everything should be mapped to a type");
            }
            if (body == null) {
                if (httpCode == 204 && "application/nuxeo-empty-list".equals(headers.get("Content-Type"))) {
                    return retrofit2.Response.success((Object)new Blobs(), (Response)response.raw());
                }
            } else if (body instanceof Connectable) {
                ((Connectable)body).reconnectWith(this);
            } else if (body instanceof List) {
                for (Object item : (List)body) {
                    if (!(item instanceof Connectable)) continue;
                    ((Connectable)item).reconnectWith(this);
                }
            }
            if (body instanceof Blob) {
                String mimeType;
                Blob blob = (Blob)body;
                String filename = null;
                String contentDisposition = headers.get("Content-Disposition");
                if (contentDisposition != null) {
                    filename = this.decodeFilename(contentDisposition);
                }
                if (filename == null) {
                    filename = blob.getFilename();
                }
                if ((mimeType = headers.get("Content-Type")) == null) {
                    mimeType = "application/octet-stream";
                }
                String lengthString = headers.get("Content-Length");
                long length = -1L;
                if (lengthString != null) {
                    length = Long.parseLong(lengthString);
                }
                if (blob instanceof StreamBlob) {
                    blob = new StreamBlob(blob.getStream(), filename, mimeType, length);
                } else if (blob instanceof FileStreamBlob) {
                    blob = new FileStreamBlob(blob.getStream(), filename, mimeType, length);
                } else if (blob instanceof FileBlob) {
                    blob = new FileBlob(((FileBlob)blob).getFile(), filename, mimeType);
                }
                return retrofit2.Response.success((Object)blob, (Response)response.raw());
            }
            return response;
        }
        catch (IOException ioe) {
            throw new NuxeoClientException("Error during deserialization of HTTP response", ioe);
        }
    }

    protected String decodeFilename(String contentDisposition) {
        String filename = contentDisposition.replaceFirst(".*filename\\*?=(UTF-8'')?(.*)", "$2");
        try {
            filename = URLDecoder.decode(filename, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return filename;
    }

    protected boolean useCache(Call<?> call) {
        return this.isCacheEnabled() && "GET".equals(call.request().method());
    }

    protected String computeCacheKey(Call<?> call) {
        MessageDigest digest;
        Request originalRequest = call.request();
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        digest.update((originalRequest.toString() + originalRequest.headers().toString()).getBytes());
        byte[] messageDigest = digest.digest();
        StringBuilder hexString = new StringBuilder();
        for (byte msg : messageDigest) {
            hexString.append(String.format("%02X", msg));
        }
        return hexString.toString();
    }

    public static class Builder
    extends AbstractBase<Builder> {
        protected final NuxeoConverterFactory converterFactory = NuxeoConverterFactory.create();
        protected Interceptor authenticationMethod;
        protected NuxeoResponseCache cache;

        public Builder() {
            this.retrofitBuilder.addConverterFactory((Converter.Factory)this.converterFactory);
            this.registerEntity("annotation", Annotation.class);
            this.registerEntity("annotations", Annotations.class);
            this.registerEntity("comment", Comment.class);
            this.registerEntity("comments", Comments.class);
            this.registerEntity("document", Document.class);
            this.registerEntity("documents", Documents.class);
            this.registerEntity("recordSet", RecordSet.class);
            this.registerEntity("task", Task.class);
            this.registerEntity("tasks", Tasks.class);
            this.registerEntity("user", User.class);
        }

        public Builder url(String url) {
            this.retrofitBuilder.baseUrl(url + "/api/v1/");
            return this;
        }

        public Builder authentication(String username, String password) {
            return this.authentication(new BasicAuthInterceptor(username, password));
        }

        public Builder authentication(Interceptor authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            return this;
        }

        public Builder interceptor(Interceptor interceptor) {
            this.okhttpBuilder.addInterceptor(interceptor);
            return this;
        }

        public Builder cache(NuxeoResponseCache cache) {
            this.cache = cache;
            return this;
        }

        public Builder registerEntity(String entityType, Class<?> clazz) {
            NuxeoConverterFactory.registerEntity(entityType, clazz);
            return this;
        }

        public NuxeoClient connect() {
            if (this.authenticationMethod == null) {
                throw new NuxeoClientException("Your client need an authentication method to connect to Nuxeo server");
            }
            this.okhttpBuilder.interceptors().add(0, this.authenticationMethod);
            NuxeoClient client = new NuxeoClient(this);
            client.currentUser = client.userManager().fetchCurrentUser();
            return client;
        }
    }
}

