/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.nuxeo.client.objects.blob.Blob;

public class Requests {
    public static RequestBody create(final Blob blob) {
        if (blob == null) {
            throw new NullPointerException("content == null");
        }
        return new RequestBody(){

            public MediaType contentType() {
                return MediaType.parse((String)blob.getMimeType());
            }

            public long contentLength() {
                return blob.getContentLength();
            }

            public void writeTo(BufferedSink sink) throws IOException {
                Source source = null;
                try {
                    source = Okio.source((InputStream)blob.getStream());
                    sink.writeAll(source);
                }
                catch (Throwable throwable) {
                    Util.closeQuietly(source);
                    throw throwable;
                }
                Util.closeQuietly((Closeable)source);
            }
        };
    }

    private Requests() {
    }
}

