/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.marshaller;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.nuxeo.client.MediaTypes;
import retrofit2.Converter;

public final class NuxeoRequestConverter<T>
implements Converter<T, RequestBody> {
    protected final JavaType javaType;
    protected final ObjectMapper objectMapper;

    protected NuxeoRequestConverter(ObjectMapper objectMapper, JavaType javaType) {
        this.objectMapper = objectMapper;
        this.javaType = javaType;
    }

    public RequestBody convert(T value) throws IOException {
        byte[] bytes = this.objectMapper.writeValueAsBytes(value);
        return RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_CHARSET_UTF_8.toOkHttpMediaType(), (byte[])bytes);
    }
}

