/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.objects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.nuxeo.client.objects.Entity;

public class Entities<E>
extends Entity
implements Iterable<E> {
    protected List<E> entries = new ArrayList();

    protected Entities(String entityType) {
        super(entityType);
    }

    protected Entities(String entityType, List<? extends E> entries) {
        this(entityType);
        this.entries.addAll(entries);
    }

    public List<E> getEntries() {
        return this.entries;
    }

    public Stream<E> streamEntries() {
        return this.entries.stream();
    }

    public E getEntry(int index) {
        return this.entries.get(index);
    }

    @JsonIgnore
    public int size() {
        return this.entries.size();
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public boolean addEntry(E entry) {
        return this.entries.add(entry);
    }

    public void sort(Comparator<? super E> comparator) {
        this.entries.sort(comparator);
    }

    @Override
    public Iterator<E> iterator() {
        return this.entries.iterator();
    }
}

