/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.objects.blob;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileCleaningTracker;
import org.nuxeo.client.objects.blob.AbstractBlob;

public class FileBlob
extends AbstractBlob {
    protected File file;

    @Deprecated
    protected FileBlob(String filename, String mediaType, long length) {
        super(filename, mediaType, length);
        this.file = null;
    }

    public FileBlob(File file) {
        this(file, file.getName());
    }

    public FileBlob(File file, String filename) {
        this(file, filename, "application/octet-stream");
    }

    public FileBlob(File file, String filename, String mediaType) {
        super(filename, mediaType, file.length());
        this.file = file;
    }

    @Override
    public InputStream getStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public File getFile() {
        return this.file;
    }

    public void track() {
        if (this.file != null) {
            FileCleaningTracker fileCleaningTracker = new FileCleaningTracker();
            fileCleaningTracker.track(this.file, (Object)this);
        }
    }

    @JsonIgnore
    protected String formatLength(long len) {
        long k = len / 1024L;
        if (k <= 0L) {
            return len + " B";
        }
        if (k < 1024L) {
            return k + " K";
        }
        return k / 1024L + " M";
    }

    public String toString() {
        return this.filename + " - " + this.mimeType + " - " + this.formatLength(this.getContentLength());
    }
}

