/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.objects.comment;

import java.io.Serializable;
import java.util.LinkedHashMap;
import org.nuxeo.client.NuxeoClient;
import org.nuxeo.client.objects.Document;
import org.nuxeo.client.objects.comment.Comment;
import org.nuxeo.client.objects.comment.Comments;

public class CommentAdapter
extends Document.AbstractAdapter<CommentAdapter> {
    protected static final String NAME = "comment";

    public CommentAdapter(Document document) {
        super(document, NAME);
    }

    protected CommentAdapter(NuxeoClient nuxeoClient, String repositoryName, String documentId) {
        super(nuxeoClient, repositoryName, documentId, NAME);
    }

    public Comment create(Comment comment) {
        comment.setParentId(this.documentId);
        return this.post(comment);
    }

    public Comments list() {
        return (Comments)this.get();
    }

    public Comments list(long pageSize, long currentPageIndex) {
        LinkedHashMap<String, Serializable> queryParams = new LinkedHashMap<String, Serializable>();
        queryParams.put("pageSize", Long.valueOf(pageSize));
        queryParams.put("currentPageIndex", Long.valueOf(currentPageIndex));
        return (Comments)this.get(queryParams);
    }

    public Comment fetch(String commentId) {
        return (Comment)this.get(commentId);
    }

    public Comment fetchByEntityId(String entityId) {
        return (Comment)this.get("external/" + entityId);
    }

    public Comment update(Comment comment) {
        return this.update(comment.getId(), comment);
    }

    public Comment update(String commentId, Comment comment) {
        comment.setParentId(this.documentId);
        return this.put(commentId, comment);
    }

    public Comment updateByEntityId(String entityId, Comment comment) {
        comment.setParentId(this.documentId);
        return this.put("external/" + entityId, comment);
    }

    public void remove(String commentId) {
        this.delete(commentId);
    }

    public void removeByEntityId(String entityId) {
        this.delete("external/" + entityId);
    }

    public CommentAdapter repliesAdapter(String parentId) {
        return new CommentAdapter(this.nuxeoClient, this.repositoryName, parentId);
    }
}

