/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.objects.upload;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.nuxeo.client.MediaTypes;
import org.nuxeo.client.NuxeoClient;
import org.nuxeo.client.Requests;
import org.nuxeo.client.methods.BatchUploadAPI;
import org.nuxeo.client.objects.AbstractConnectable;
import org.nuxeo.client.objects.blob.Blob;
import org.nuxeo.client.objects.blob.FileBlob;
import org.nuxeo.client.objects.operation.OperationBody;
import org.nuxeo.client.objects.upload.BatchBlob;
import org.nuxeo.client.spi.NuxeoClientException;

public class BatchUpload
extends AbstractConnectable<BatchUploadAPI, BatchUpload> {
    @JsonIgnore
    protected int chunkSize;
    protected String name;
    protected String batchId;
    protected String fileIdx;
    protected String uploadType;
    protected long uploadedSize;
    protected int[] uploadedChunkIds;
    protected int chunkCount;

    protected BatchUpload() {
        super(BatchUploadAPI.class);
    }

    protected BatchUpload(NuxeoClient nuxeoClient, String batchId) {
        super(BatchUploadAPI.class, nuxeoClient);
        this.batchId = batchId;
    }

    protected BatchUpload(NuxeoClient nuxeoClient, String batchId, String fileIdx) {
        this(nuxeoClient, batchId);
        this.fileIdx = fileIdx;
    }

    public String getName() {
        return this.name;
    }

    public String getBatchId() {
        return this.batchId;
    }

    public String getFileIdx() {
        return this.fileIdx;
    }

    public String getUploadType() {
        return this.uploadType;
    }

    public long getUploadedSize() {
        return this.uploadedSize;
    }

    public long getSize() {
        return this.uploadedSize;
    }

    public int[] getUploadedChunkIds() {
        return this.uploadedChunkIds;
    }

    public int getChunkCount() {
        return this.chunkCount;
    }

    protected void setSize(long size) {
        this.uploadedSize = size;
    }

    @Deprecated
    public BatchUpload upload(String fileIdx, File file) {
        return this.upload(fileIdx, new FileBlob(file));
    }

    @Deprecated
    public BatchUpload upload(String fileIdx, File file, String name) {
        return this.upload(fileIdx, new FileBlob(file, name));
    }

    @Deprecated
    public BatchUpload upload(String fileIdx, File file, String name, String fileType) {
        return this.upload(fileIdx, new FileBlob(file, name, fileType));
    }

    @Deprecated
    public BatchUpload upload(String fileIdx, File file, String name, String fileType, long length) {
        return this.upload(fileIdx, new FileBlob(file, name, fileType));
    }

    public BatchUpload upload(String fileIdx, Blob blob) {
        BatchUpload batchUpload;
        String filename = blob.getFilename();
        String mimeType = blob.getMimeType();
        long length = blob.getContentLength();
        if (this.chunkSize == 0) {
            RequestBody fbody = Requests.create(blob);
            BatchUpload response = this.fetchResponse(((BatchUploadAPI)this.api).upload(filename, length, mimeType, "normal", 0L, 1L, this.batchId, fileIdx, fbody));
            response.name = filename;
            response.batchId = this.batchId;
            response.fileIdx = fileIdx;
            return response;
        }
        if (length <= 0L) {
            throw new NuxeoClientException("You have to give blob length in order to upload it by chunk");
        }
        BatchUpload response = null;
        byte[] buffer = new byte[this.chunkSize];
        long chunkIndex = 0L;
        long chunkNumber = (length + (long)this.chunkSize - 1L) / (long)this.chunkSize;
        BufferedInputStream bis = new BufferedInputStream(blob.getStream());
        try {
            int bufferLength;
            while ((bufferLength = bis.read(buffer)) > 0) {
                RequestBody requestBody = RequestBody.create((MediaType)MediaTypes.APPLICATION_OCTET_STREAM.toOkHttpMediaType(), (byte[])buffer, (int)0, (int)bufferLength);
                response = this.fetchResponse(((BatchUploadAPI)this.api).upload(filename, length, mimeType, "chunked", chunkIndex, chunkNumber, this.batchId, fileIdx, requestBody));
                ++chunkIndex;
            }
            if (response != null) {
                response.name = filename;
                response.chunkSize = this.chunkSize;
                response.uploadedSize = length;
            }
            batchUpload = response;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException reason) {
                throw new NuxeoClientException("Error during batch upload", reason);
            }
        }
        bis.close();
        return batchUpload;
    }

    public void cancel() {
        this.fetchResponse(((BatchUploadAPI)this.api).cancel(this.batchId));
    }

    public List<BatchUpload> fetchBatchUploads() {
        List<BatchUpload> response = this.fetchResponse(((BatchUploadAPI)this.api).fetchBatchUploads(this.batchId));
        int i = 0;
        for (BatchUpload upload : response) {
            upload.batchId = this.batchId;
            upload.fileIdx = String.valueOf(++i);
        }
        return response;
    }

    public BatchUpload fetchBatchUpload() {
        if (this.fileIdx == null) {
            throw new NuxeoClientException("Unable to fetch BatchUpload because fileIdx is null");
        }
        return this.fetchBatchUpload(this.fileIdx);
    }

    public BatchUpload fetchBatchUpload(String fileIdx) {
        BatchUpload response = this.fetchResponse(((BatchUploadAPI)this.api).fetchBatchUpload(this.batchId, fileIdx));
        if (this.name != null) {
            response.name = this.name;
        }
        response.batchId = this.batchId;
        response.fileIdx = fileIdx;
        return response;
    }

    public BatchBlob getBatchBlob() {
        if (this.fileIdx == null) {
            throw new NuxeoClientException("Unable to instantiate BatchBlob because fileIdx is null");
        }
        return this.getBatchBlob(this.fileIdx);
    }

    public BatchBlob getBatchBlob(String fileIdx) {
        return new BatchBlob(this.batchId, fileIdx);
    }

    public BatchUpload chunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
        this.uploadType = "chunked";
        return this;
    }

    public BatchUpload enableChunk() {
        return this.chunkSize(0x100000);
    }

    public BatchUploadOperation operation(String operationId) {
        if (this.fileIdx == null) {
            throw new NuxeoClientException("Unable to execute operation on a BatchUpload not representing a blob (fileIdx == null)");
        }
        return new BatchUploadOperation(this.fileIdx, operationId);
    }

    public class BatchUploadOperation {
        protected final String fileIdx;
        protected final String operationId;
        protected final OperationBody body;

        public BatchUploadOperation(String fileIdx, String operationId) {
            this.fileIdx = fileIdx;
            this.operationId = operationId;
            this.body = new OperationBody();
        }

        public BatchUploadOperation param(String key, Object parameter) {
            this.body.getParameters().put(key, parameter);
            return this;
        }

        public BatchUploadOperation context(String key, Object contextValue) {
            this.body.getContext().put(key, contextValue);
            return this;
        }

        public BatchUploadOperation parameters(Map<String, Object> parameters) {
            this.body.setParameters(parameters);
            return this;
        }

        public BatchUploadOperation context(Map<String, Object> context) {
            this.body.setContext(context);
            return this;
        }

        public <T> T execute() {
            return (T)BatchUpload.this.fetchResponse(((BatchUploadAPI)BatchUpload.this.api).execute(BatchUpload.this.batchId, this.fileIdx, this.operationId, this.body));
        }
    }
}

