/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.marshaller;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.nuxeo.client.objects.config.Schema;

public class DocTypeSchemaDeserializer
extends StdDeserializer<List<Schema>> {
    protected DocTypeSchemaDeserializer() {
        super(List.class);
    }

    public List<Schema> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ArrayNode schemas = (ArrayNode)p.readValueAsTree();
        if (schemas.size() == 0) {
            return Collections.emptyList();
        }
        if (schemas.get(0).isTextual()) {
            ArrayList<Schema> objSchemas = new ArrayList<Schema>(schemas.size());
            Iterator schemasIt = schemas.elements();
            while (schemasIt.hasNext()) {
                JsonNode schema = (JsonNode)schemasIt.next();
                objSchemas.add(new Schema(schema.textValue(), null, null));
            }
            return objSchemas;
        }
        ArrayList<Schema> objSchemas = new ArrayList<Schema>(schemas.size());
        ObjectCodec codec = p.getCodec();
        Iterator schemasIt = schemas.elements();
        while (schemasIt.hasNext()) {
            JsonNode schema = (JsonNode)schemasIt.next();
            objSchemas.add((Schema)codec.treeToValue((TreeNode)schema, Schema.class));
        }
        return objSchemas;
    }
}

