/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.marshaller;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import okhttp3.ResponseBody;
import org.nuxeo.client.MediaType;
import org.nuxeo.client.MediaTypes;
import org.nuxeo.client.objects.blob.Blobs;
import org.nuxeo.client.objects.blob.FileBlob;
import org.nuxeo.client.objects.blob.FileStreamBlob;
import org.nuxeo.client.objects.blob.StreamBlob;
import org.nuxeo.client.spi.NuxeoClientException;
import org.nuxeo.client.util.IOUtils;
import retrofit2.Converter;

public final class NuxeoResponseConverter<T>
implements Converter<ResponseBody, T> {
    protected final JavaType javaType;
    protected final ObjectMapper objectMapper;
    protected final Map<String, Class<?>> entityTypeToClass;

    protected NuxeoResponseConverter(ObjectMapper objectMapper, JavaType javaType, Map<String, Class<?>> entityTypeToClass) {
        this.objectMapper = objectMapper;
        this.javaType = javaType;
        this.entityTypeToClass = entityTypeToClass;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T convert(ResponseBody body) throws IOException {
        MediaType mediaType = MediaType.fromOkHttpMediaType(body.contentType());
        if (!MediaTypes.APPLICATION_JSON.equalsTypeSubTypeWithoutSuffix(mediaType)) {
            if (mediaType.type().equals("multipart")) {
                ArrayList<FileBlob> blobs = new ArrayList<FileBlob>();
                try (InputStream is = body.byteStream();){
                    MimeMultipart mp = new MimeMultipart((DataSource)new ByteArrayDataSource(is, mediaType.toString()));
                    int size = mp.getCount();
                    int i = 0;
                    while (i < size) {
                        BodyPart part = mp.getBodyPart(i);
                        blobs.add(new FileBlob(IOUtils.copyToTempFile(part.getInputStream()), part.getFileName(), part.getContentType()));
                        ++i;
                    }
                    return (T)new Blobs(blobs);
                }
                catch (MessagingException reason) {
                    throw new IOException(reason);
                }
            }
            if (this.javaType.getRawClass().equals(StreamBlob.class)) {
                return (T)new StreamBlob(body.byteStream(), null, mediaType.toString());
            }
            if (!this.javaType.getRawClass().equals(FileBlob.class)) return (T)new FileStreamBlob(body.byteStream());
            File tmpFile = IOUtils.copyToTempFile(body.byteStream());
            return (T)new FileBlob(tmpFile);
        }
        try (Reader reader = body.charStream();){
            if (this.javaType.getRawClass().equals(Object.class)) {
                String entityType;
                Class<?> entityClass;
                JsonNode payload = this.objectMapper.readTree(reader);
                if (payload.path("entity-type").isTextual() && (entityClass = this.entityTypeToClass.get(entityType = payload.get("entity-type").textValue())) != null) {
                    Object object = this.objectMapper.readerFor(entityClass).readValue(payload);
                    return (T)object;
                }
                String string = this.objectMapper.writeValueAsString((Object)payload);
                return (T)string;
            }
            Object object = this.objectMapper.readerFor(this.javaType).readValue(reader);
            return (T)object;
        }
        catch (IOException reason) {
            throw new NuxeoClientException("Error during deserialization of HTTP body", reason);
        }
    }
}

