/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.objects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.nuxeo.client.NuxeoClient;
import org.nuxeo.client.marshaller.EntityValueDeserializer;
import org.nuxeo.client.methods.RepositoryAPI;
import org.nuxeo.client.objects.AbstractConnectable;
import org.nuxeo.client.objects.Connectable;
import org.nuxeo.client.objects.Documents;
import org.nuxeo.client.objects.RepositoryEntity;
import org.nuxeo.client.objects.acl.ACE;
import org.nuxeo.client.objects.acl.ACP;
import org.nuxeo.client.objects.audit.Audit;
import org.nuxeo.client.objects.blob.FileBlob;
import org.nuxeo.client.objects.blob.StreamBlob;
import org.nuxeo.client.objects.task.Task;
import org.nuxeo.client.objects.task.Tasks;
import org.nuxeo.client.objects.workflow.Workflow;
import org.nuxeo.client.objects.workflow.Workflows;
import org.nuxeo.client.spi.NuxeoClientException;
import retrofit2.Callback;

public class Document
extends RepositoryEntity<RepositoryAPI, Document> {
    public static final String DEFAULT_FILE_CONTENT = "file:content";
    protected static final String DELETED_STATE = "deleted";
    protected String path;
    protected String type;
    protected String state;
    protected String lockOwner;
    protected String lockCreated;
    protected String versionLabel;
    protected String isCheckedOut;
    protected String lastModified;
    @JsonProperty(value="properties")
    @JsonDeserialize(contentUsing=EntityValueDeserializer.class)
    protected Map<String, Object> properties = new HashMap<String, Object>();
    @JsonIgnore
    protected Map<String, Object> dirtyProperties = new HashMap<String, Object>();
    @JsonDeserialize(contentUsing=EntityValueDeserializer.class)
    protected Map<String, Object> contextParameters = new HashMap<String, Object>();
    protected String changeToken;
    protected List<String> facets;
    protected String parentRef;
    protected String uid;
    protected String title;
    protected String name;
    @JsonProperty(value="isProxy")
    protected boolean isProxy;
    @JsonProperty(value="isTrashed")
    protected Boolean isTrashed;
    @JsonProperty(value="isRecord")
    protected boolean isRecord;
    protected String retainUntil;
    @JsonProperty(value="hasLegalHold")
    protected boolean hasLegalHold;
    @JsonProperty(value="isUnderRetentionOrLegalHold")
    protected boolean isUnderRetentionOrLegalHold;
    @JsonProperty(value="isVersion")
    protected boolean isVersion;
    protected String versionableId;

    protected Document() {
        this("File", "File");
    }

    protected Document(String uid, String type) {
        super("document", RepositoryAPI.class);
        this.uid = uid;
        this.type = type;
    }

    protected Document(Document document) {
        super("document", RepositoryAPI.class);
        this.type = "File";
        try {
            Class<?> superclass = this.getClass().getSuperclass();
            while (!superclass.equals(Document.class)) {
                if (!(superclass = superclass.getSuperclass()).equals(Object.class)) continue;
                throw new NuxeoClientException("You should never use this constructor unless you're using a subclass of Document");
            }
            for (Field field : document.getClass().getDeclaredFields()) {
                if (Modifier.isFinal(field.getModifiers())) continue;
                superclass.getDeclaredField(field.getName()).set(this, field.get(document));
            }
        }
        catch (ReflectiveOperationException reason) {
            throw new NuxeoClientException("Error during construction of document adapter", reason);
        }
    }

    public static Document createWithId(String uid, String type) {
        return new Document(uid, type);
    }

    public static Document createWithName(String name, String type) {
        Document document = new Document(null, type);
        document.name = name;
        return document;
    }

    public String getId() {
        return this.uid;
    }

    public String getPath() {
        return this.path;
    }

    public String getType() {
        return this.type;
    }

    public String getLock() {
        if (this.lockOwner != null && this.lockCreated != null) {
            return this.lockOwner + ":" + this.lockCreated;
        }
        return null;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public String getLockCreated() {
        return this.lockCreated;
    }

    public boolean isLocked() {
        return this.lockOwner != null;
    }

    public String getState() {
        return this.state;
    }

    public String getVersionLabel() {
        return this.versionLabel;
    }

    public Boolean isCheckedOut() {
        return this.isCheckedOut == null ? null : Boolean.valueOf(this.isCheckedOut);
    }

    public String getTitle() {
        return this.title;
    }

    public String getChangeToken() {
        return this.changeToken;
    }

    public List<String> getFacets() {
        return this.facets;
    }

    public String getIsCheckedOut() {
        return this.isCheckedOut;
    }

    public String getParentRef() {
        return this.parentRef;
    }

    public String getUid() {
        return this.uid;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRecord() {
        return this.isRecord;
    }

    public void setRecord(boolean record) {
        this.isRecord = record;
    }

    public String getRetainUntil() {
        return this.retainUntil;
    }

    public void setRetainUntil(String retainUntil) {
        this.retainUntil = retainUntil;
    }

    public boolean hasLegalHold() {
        return this.hasLegalHold;
    }

    public void setHasLegalHold(boolean hasLegalHold) {
        this.hasLegalHold = hasLegalHold;
    }

    public boolean isUnderRetentionOrLegalHold() {
        return this.isUnderRetentionOrLegalHold;
    }

    public void setUnderRetentionOrLegalHold(boolean underRetentionOrLegalHold) {
        this.isUnderRetentionOrLegalHold = underRetentionOrLegalHold;
    }

    public boolean isVersion() {
        return this.isVersion;
    }

    public void setVersion(boolean version) {
        this.isVersion = version;
    }

    public String getVersionableId() {
        return this.versionableId;
    }

    public void setVersionableId(String versionableId) {
        this.versionableId = versionableId;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public <T> T getPropertyValue(String xpath) {
        List<String> segments = Arrays.asList(xpath.split("/"));
        return (T)this.getPropertyValue(this.properties, segments);
    }

    protected Object getPropertyValue(Object value, List<String> segments) {
        if (segments.isEmpty()) {
            return value;
        }
        String segment = segments.get(0);
        List<String> subSegments = segments.subList(1, segments.size());
        if (value instanceof Map) {
            if (segment.matches("\\d+") || "*".equals(segment)) {
                throw new NuxeoClientException("Unable to get map element with segment=" + segment);
            }
            return this.getPropertyValue(((Map)value).get(segment), subSegments);
        }
        if (value instanceof List) {
            if (segment.matches("\\d+")) {
                int index = Integer.parseInt(segment);
                List list = (List)value;
                return this.getPropertyValue(list.size() > index ? list.get(index) : null, subSegments);
            }
            if ("*".equals(segment)) {
                List list = (List)value;
                ArrayList<Object> result = new ArrayList<Object>(list.size());
                for (Object element : list) {
                    result.add(this.getPropertyValue(element, subSegments));
                }
                return result;
            }
            throw new NuxeoClientException("Unable to get list element with segment=" + segment);
        }
        if (value != null) {
            throw new NuxeoClientException("Unable to traverse " + value.getClass().getSimpleName() + " object with segment=" + segment);
        }
        return null;
    }

    public void setPropertyValue(String key, Object value) {
        this.rejectIfDateFound(key, value);
        this.properties.put(key, value);
        this.dirtyProperties.put(key, value);
    }

    @JsonIgnore
    public void setProperties(Map<String, Object> properties) {
        this.properties.clear();
        if (properties != null) {
            this.rejectIfDateFound(null, properties);
            this.properties.putAll(properties);
        }
        this.dirtyProperties.clear();
        if (properties != null) {
            this.dirtyProperties.putAll(properties);
        }
    }

    public Map<String, Object> getDirtyProperties() {
        return this.dirtyProperties;
    }

    public void setDirtyProperties(Map<String, Object> dirtyProperties) {
        this.dirtyProperties.clear();
        if (dirtyProperties != null) {
            this.rejectIfDateFound(null, dirtyProperties);
            this.dirtyProperties.putAll(dirtyProperties);
        }
    }

    public <T> T getContextParameter(String key) {
        return (T)this.contextParameters.get(key);
    }

    public Map<String, Object> getContextParameters() {
        return this.contextParameters;
    }

    public void setContextParameters(Map<String, Object> contextParameters) {
        this.contextParameters.clear();
        if (contextParameters != null) {
            this.contextParameters.putAll(contextParameters);
        }
    }

    public Document updateDocument() {
        this.setProperties(this.getDirtyProperties());
        if (this.repositoryName == null) {
            return this.fetchResponse(((RepositoryAPI)this.api).updateDocument(this.uid, this));
        }
        return this.fetchResponse(((RepositoryAPI)this.api).updateDocument(this.uid, this, this.repositoryName));
    }

    public Audit fetchAudit() {
        if (this.repositoryName == null) {
            return this.fetchResponse(((RepositoryAPI)this.api).fetchAuditById(this.uid));
        }
        return this.fetchResponse(((RepositoryAPI)this.api).fetchAuditById(this.uid, this.repositoryName));
    }

    public void fetchAudit(Callback<Audit> callback) {
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).fetchAuditById(this.uid), callback);
        }
        this.fetchResponse(((RepositoryAPI)this.api).fetchAuditById(this.uid, this.repositoryName), callback);
    }

    public ACP fetchPermissions() {
        if (this.repositoryName == null) {
            return this.fetchResponse(((RepositoryAPI)this.api).fetchPermissionsById(this.uid));
        }
        return this.fetchResponse(((RepositoryAPI)this.api).fetchPermissionsById(this.uid, this.repositoryName));
    }

    public Document addPermission(ACE ace) {
        Map<String, Object> params = this.toAutomationParameters(ace);
        params.put("user", ace.getUsername());
        return (Document)this.nuxeoClient.operation("Document.AddPermission").input(this).parameters(params).execute();
    }

    protected Map<String, Object> toAutomationParameters(ACE ace) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("permission", ace.getPermission());
        params.put("begin", ace.getBeginAsString());
        params.put("end", ace.getEndAsString());
        params.put("creator", ace.getCreator());
        params.put("blockInheritance", ace.isBlockInheritance());
        params.put("comment", ace.getComment());
        params.put("notify", ace.isNotify());
        return params;
    }

    public Document addInvitation(ACE ace, String email) {
        Map<String, Object> params = this.toAutomationParameters(ace);
        params.put("email", email);
        return (Document)this.nuxeoClient.operation("Document.AddPermission").input(this).parameters(params).execute();
    }

    public void removePermission(String username) {
        this.removePermission(null, username, "local");
    }

    public void removePermission(String aceId, String username, String aclName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", aceId);
        params.put("user", username);
        params.put("acl", aclName);
        this.nuxeoClient.operation("Document.RemovePermission").input(this).parameters(params).execute();
    }

    public void fetchPermissions(Callback<ACP> callback) {
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).fetchPermissionsById(this.uid), callback);
        }
        this.fetchResponse(((RepositoryAPI)this.api).fetchPermissionsById(this.uid, this.repositoryName), callback);
    }

    public void addPermission(ACE ace, Callback<Document> callback) {
        Map<String, Object> params = this.toAutomationParameters(ace);
        params.put("user", ace.getUsername());
        this.nuxeoClient.operation("Document.AddPermission").input(this).parameters(params).execute(callback);
    }

    public void addInvitation(ACE ace, String email, Callback<Document> callback) {
        Map<String, Object> params = this.toAutomationParameters(ace);
        params.put("email", email);
        this.nuxeoClient.operation("Document.AddPermission").input(this).parameters(params).execute(callback);
    }

    public Documents fetchChildren() {
        if (this.repositoryName == null) {
            return this.fetchResponse(((RepositoryAPI)this.api).fetchChildrenById(this.uid));
        }
        return this.fetchResponse(((RepositoryAPI)this.api).fetchChildrenById(this.uid, this.repositoryName));
    }

    public void fetchChildren(Callback<Documents> callback) {
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).fetchChildrenById(this.uid), callback);
        }
        this.fetchResponse(((RepositoryAPI)this.api).fetchChildrenById(this.uid, this.repositoryName), callback);
    }

    @Deprecated
    public FileBlob fetchBlob() {
        return this.fetchBlob(DEFAULT_FILE_CONTENT);
    }

    @Deprecated
    public FileBlob fetchBlob(String fieldPath) {
        if (this.repositoryName == null) {
            return this.fetchResponse(((RepositoryAPI)this.api).fetchBlobById(this.uid, fieldPath));
        }
        return this.fetchResponse(((RepositoryAPI)this.api).fetchBlobById(this.uid, fieldPath, this.repositoryName));
    }

    public StreamBlob streamBlob() {
        return this.streamBlob(DEFAULT_FILE_CONTENT);
    }

    public StreamBlob streamBlob(String fieldPath) {
        if (this.repositoryName == null) {
            return this.fetchResponse(((RepositoryAPI)this.api).streamBlobById(this.uid, fieldPath));
        }
        return this.fetchResponse(((RepositoryAPI)this.api).streamBlobById(this.uid, fieldPath, this.repositoryName));
    }

    @Deprecated
    public void fetchBlob(Callback<FileBlob> callback) {
        this.fetchBlob(DEFAULT_FILE_CONTENT, callback);
    }

    @Deprecated
    public void fetchBlob(String fieldPath, Callback<FileBlob> callback) {
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).fetchBlobById(this.uid, fieldPath), callback);
        }
        this.fetchResponse(((RepositoryAPI)this.api).fetchBlobById(this.uid, fieldPath, this.repositoryName), callback);
    }

    public void streamBlob(Callback<StreamBlob> callback) {
        this.streamBlob(DEFAULT_FILE_CONTENT, callback);
    }

    public void streamBlob(String fieldPath, Callback<StreamBlob> callback) {
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).streamBlobById(this.uid, fieldPath), callback);
        }
        this.fetchResponse(((RepositoryAPI)this.api).streamBlobById(this.uid, fieldPath, this.repositoryName), callback);
    }

    public Workflows fetchWorkflowInstances() {
        if (this.repositoryName == null) {
            return this.fetchResponse(((RepositoryAPI)this.api).fetchWorkflowInstances(this.uid));
        }
        return this.fetchResponse(((RepositoryAPI)this.api).fetchWorkflowInstances(this.uid, this.repositoryName));
    }

    public Workflow startWorkflowInstance(Workflow workflow) {
        if (this.repositoryName == null) {
            return this.fetchResponse(((RepositoryAPI)this.api).startWorkflowInstanceWithDocId(this.uid, workflow));
        }
        return this.fetchResponse(((RepositoryAPI)this.api).startWorkflowInstanceWithDocId(this.uid, workflow, this.repositoryName));
    }

    public void fetchWorkflowInstances(Callback<Workflows> callback) {
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).fetchWorkflowInstances(this.uid), callback);
        }
        this.fetchResponse(((RepositoryAPI)this.api).fetchWorkflowInstances(this.uid, this.repositoryName), callback);
    }

    public void startWorkflowInstance(Workflow workflow, Callback<Workflow> callback) {
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).startWorkflowInstanceWithDocId(this.uid, workflow), callback);
        }
        this.fetchResponse(((RepositoryAPI)this.api).startWorkflowInstanceWithDocId(this.uid, workflow, this.repositoryName), callback);
    }

    @Deprecated
    public Task fetchTask() {
        return (Task)this.adapter("task").get();
    }

    public Tasks fetchTasks() {
        return (Tasks)this.adapter("task").get();
    }

    public boolean isProxy() {
        return this.isProxy;
    }

    private void rejectIfDateFound(String key, Object value) {
        block5: {
            block6: {
                block4: {
                    if (value instanceof Calendar || value instanceof Date) {
                        throw new IllegalArgumentException(String.format("Property '%s' has value of type '%s'. However, date values are not supported in Nuxeo Java Client. Please convert it to String with ISO 8601 format \"yyyy-MM-dd'T'HH:mm:ss.SSSXXX\" before setting it as property.", key, value.getClass().getTypeName()));
                    }
                    if (!(value instanceof Collection)) break block4;
                    for (Object item : (Collection)value) {
                        this.rejectIfDateFound(key, item);
                    }
                    break block5;
                }
                if (!(value instanceof Map)) break block6;
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    this.rejectIfDateFound((String)entry.getKey(), entry.getValue());
                }
                break block5;
            }
            if (value == null || !value.getClass().isArray()) break block5;
            for (int i = 0; i < Array.getLength(value); ++i) {
                this.rejectIfDateFound(key, Array.get(value, i));
            }
        }
    }

    public boolean isTrashed() {
        return this.isTrashed != null ? this.isTrashed.booleanValue() : DELETED_STATE.equals(this.state);
    }

    public Document trash() {
        return (Document)this.nuxeoClient.operation("Document.Trash").input(this).execute();
    }

    public Document untrash() {
        return (Document)this.nuxeoClient.operation("Document.Untrash").input(this).execute();
    }

    public Adapter adapter(String adapter) {
        return new Adapter(this, adapter);
    }

    public <A extends AbstractAdapter> A adapter(Function<Document, A> creator) {
        return (A)((AbstractAdapter)creator.apply(this));
    }

    @Override
    public void reconnectWith(NuxeoClient nuxeoClient) {
        super.reconnectWith(nuxeoClient);
        BiConsumer<String, Object> reconnect = (key, value) -> {
            if (value instanceof Connectable) {
                ((Connectable)value).reconnectWith(nuxeoClient);
            }
        };
        this.properties.forEach(reconnect);
        this.contextParameters.forEach(reconnect);
    }

    public static abstract class AbstractAdapter<A extends AbstractAdapter<A>>
    extends AbstractConnectable<RepositoryAPI, A> {
        protected final String repositoryName;
        protected final String documentId;
        protected final String adapter;

        protected AbstractAdapter(NuxeoClient nuxeoClient, String repositoryName, String documentId, String adapter) {
            super(RepositoryAPI.class, nuxeoClient);
            this.repositoryName = repositoryName;
            this.documentId = documentId;
            this.adapter = adapter;
        }

        public AbstractAdapter(Document document, String adapter) {
            this(document.nuxeoClient, document.repositoryName, document.uid, adapter);
        }

        public String getDocumentId() {
            return this.documentId;
        }

        public <O> O get() {
            return this.get("");
        }

        public <O> O get(String pathSuffix) {
            return this.get(pathSuffix, Collections.emptyMap());
        }

        public <O> O get(Map<String, Serializable> queryParams) {
            return this.get("", queryParams);
        }

        public <O> O get(String pathSuffix, Map<String, Serializable> queryParams) {
            if (this.repositoryName == null) {
                return (O)this.fetchResponse(((RepositoryAPI)this.api).fetchForAdapter(this.documentId, this.adapter, pathSuffix, queryParams));
            }
            return (O)this.fetchResponse(((RepositoryAPI)this.api).fetchForAdapter(this.repositoryName, this.documentId, this.adapter, pathSuffix, queryParams));
        }

        public <O> O post(O object) {
            return this.post("", object);
        }

        public <O> O post(String pathSuffix, O object) {
            return this.post(pathSuffix, Collections.emptyMap(), object);
        }

        public <O> O post(Map<String, Serializable> queryParams, O object) {
            return this.post("", queryParams, object);
        }

        public <O> O post(String pathSuffix, Map<String, Serializable> queryParams, O object) {
            if (this.repositoryName == null) {
                return (O)this.fetchResponse(((RepositoryAPI)this.api).createForAdapter(this.documentId, this.adapter, pathSuffix, queryParams, object));
            }
            return (O)this.fetchResponse(((RepositoryAPI)this.api).createForAdapter(this.repositoryName, this.documentId, this.adapter, pathSuffix, queryParams, object));
        }

        public <O> O put(O object) {
            return this.put("", object);
        }

        public <O> O put(String pathSuffix, O object) {
            return this.put(pathSuffix, Collections.emptyMap(), object);
        }

        public <O> O put(Map<String, Serializable> queryParams, O object) {
            return this.put("", queryParams, object);
        }

        public <O> O put(String pathSuffix, Map<String, Serializable> queryParams, O object) {
            if (this.repositoryName == null) {
                return (O)this.fetchResponse(((RepositoryAPI)this.api).updateForAdapter(this.documentId, this.adapter, pathSuffix, queryParams, object));
            }
            return (O)this.fetchResponse(((RepositoryAPI)this.api).updateForAdapter(this.repositoryName, this.documentId, this.adapter, pathSuffix, queryParams, object));
        }

        public void delete() {
            this.delete("");
        }

        public void delete(String pathSuffix) {
            this.delete(pathSuffix, Collections.emptyMap());
        }

        public void delete(Map<String, Serializable> queryParams) {
            this.delete("", queryParams);
        }

        public void delete(String pathSuffix, Map<String, Serializable> queryParams) {
            if (this.repositoryName == null) {
                this.fetchResponse(((RepositoryAPI)this.api).deleteForAdapter(this.documentId, this.adapter, pathSuffix, queryParams));
            } else {
                this.fetchResponse(((RepositoryAPI)this.api).deleteForAdapter(this.repositoryName, this.documentId, this.adapter, pathSuffix, queryParams));
            }
        }
    }

    public static class Adapter
    extends AbstractAdapter<Adapter> {
        protected Adapter(NuxeoClient nuxeoClient, String repositoryName, String documentId, String adapter) {
            super(nuxeoClient, repositoryName, documentId, adapter);
        }

        public Adapter(Document document, String adapter) {
            super(document, adapter);
        }
    }
}

