/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.objects;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ProxyRetrofitQueryMap
extends HashMap<String, Serializable> {
    public ProxyRetrofitQueryMap(Map<String, Serializable> m) {
        super(m);
    }

    @Override
    public Set<Map.Entry<String, Serializable>> entrySet() {
        Set originSet = super.entrySet();
        HashSet<Map.Entry<String, Serializable>> newSet = new HashSet<Map.Entry<String, Serializable>>();
        for (Map.Entry entry : originSet) {
            String entryKey = (String)entry.getKey();
            if (entryKey == null) {
                throw new IllegalArgumentException("Query map contained null key.");
            }
            Object entryValue = entry.getValue();
            if (entryValue == null) {
                throw new IllegalArgumentException("Query map contained null value for key '" + entryKey + "'.");
            }
            if (entryValue instanceof Iterable) {
                for (Serializable arrayValue : (Iterable)entryValue) {
                    if (arrayValue == null) continue;
                    AbstractMap.SimpleEntry<String, Serializable> newEntry = new AbstractMap.SimpleEntry<String, Serializable>(entryKey, arrayValue);
                    newSet.add(newEntry);
                }
                continue;
            }
            newSet.add(entry);
        }
        return newSet;
    }
}

