/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.objects.comment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nuxeo.client.objects.Document;
import org.nuxeo.client.objects.ProxyRetrofitQueryMap;
import org.nuxeo.client.objects.comment.Annotation;
import org.nuxeo.client.objects.comment.Annotations;
import org.nuxeo.client.objects.comment.CommentAdapter;
import org.nuxeo.client.objects.comment.Comments;

public class AnnotationAdapter
extends Document.AbstractAdapter<AnnotationAdapter> {
    public AnnotationAdapter(Document document) {
        super(document, "annotation");
    }

    public Annotation create(Annotation annotation) {
        annotation.setParentId(this.documentId);
        return this.post(annotation);
    }

    public Annotations list() {
        return this.list("file:content");
    }

    public Annotations list(String xpath) {
        return (Annotations)this.get(Collections.singletonMap("xpath", xpath));
    }

    public Annotation fetch(String annotationId) {
        return (Annotation)this.get(annotationId);
    }

    public Annotation fetchByEntityId(String entityId) {
        return (Annotation)this.get("external/" + entityId);
    }

    public Comments fetchComments(List<String> annotationIds) {
        return (Comments)this.get("comments", new ProxyRetrofitQueryMap(Collections.singletonMap("annotationIds", new ArrayList<String>(annotationIds))));
    }

    public Annotation update(Annotation annotation) {
        return this.update(annotation.getId(), annotation);
    }

    public Annotation update(String annotationId, Annotation annotation) {
        annotation.setParentId(this.documentId);
        return this.put(annotationId, annotation);
    }

    public Annotation updateByEntityId(String entityId, Annotation annotation) {
        annotation.setParentId(this.documentId);
        return this.put("external/" + entityId, annotation);
    }

    public void remove(String annotationId) {
        this.delete(annotationId);
    }

    public void removeByEntityId(String entityId) {
        this.delete("external/" + entityId);
    }

    public CommentAdapter repliesAdapter(String commentId) {
        return new CommentAdapter(this.nuxeoClient, this.repositoryName, commentId);
    }
}

