/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.objects.user;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.stream.Collectors;
import org.nuxeo.client.methods.UserManagerAPI;
import org.nuxeo.client.objects.ConnectableEntity;
import org.nuxeo.client.objects.user.Groups;
import org.nuxeo.client.objects.user.User;
import org.nuxeo.client.objects.user.Users;

public class Group
extends ConnectableEntity<UserManagerAPI, Group> {
    @JsonProperty(value="groupname")
    protected String groupName;
    @JsonProperty(value="grouplabel")
    protected String groupLabel;
    protected List<String> memberUsers;
    protected List<String> memberGroups;
    protected List<String> parentGroups;

    public Group() {
        super("group", UserManagerAPI.class);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupLabel() {
        return this.groupLabel;
    }

    public void setGroupLabel(String groupLabel) {
        this.groupLabel = groupLabel;
    }

    public List<String> getMemberUsers() {
        return this.memberUsers;
    }

    public Users fetchMemberUsers() {
        Users users = this.fetchResponse(((UserManagerAPI)this.api).fetchGroupMemberUsers(this.getGroupName()));
        this.memberUsers = users.streamEntries().map(User::getUserName).collect(Collectors.toList());
        return users;
    }

    public void setMemberUsers(List<String> memberUsers) {
        this.memberUsers = memberUsers;
    }

    public List<String> getMemberGroups() {
        return this.memberGroups;
    }

    public Groups fetchMemberGroups() {
        Groups groups = this.fetchResponse(((UserManagerAPI)this.api).fetchGroupMemberGroups(this.getGroupName()));
        this.memberGroups = groups.streamEntries().map(Group::getGroupName).collect(Collectors.toList());
        return groups;
    }

    public void setMemberGroups(List<String> memberGroups) {
        this.memberGroups = memberGroups;
    }

    public List<String> getParentGroups() {
        return this.parentGroups;
    }

    public void setParentGroups(List<String> parentGroups) {
        this.parentGroups = parentGroups;
    }
}

