/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.spi.auth;

import java.io.IOException;
import java.time.Instant;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.nuxeo.client.spi.auth.oauth2.OAuth2Client;
import org.nuxeo.client.spi.auth.oauth2.OAuth2Token;

public class OAuth2AuthInterceptor
implements Interceptor {
    protected OAuth2Token token;
    protected OAuth2Client oAuth2Client;

    protected OAuth2AuthInterceptor(OAuth2Token token, OAuth2Client oAuth2Client) {
        this.token = token;
        this.oAuth2Client = oAuth2Client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response intercept(Interceptor.Chain chain) throws IOException {
        if (this.needToRefresh()) {
            OAuth2AuthInterceptor oAuth2AuthInterceptor = this;
            synchronized (oAuth2AuthInterceptor) {
                if (this.needToRefresh()) {
                    this.token = this.oAuth2Client.refreshToken(this.token);
                }
            }
        }
        Request request = chain.request().newBuilder().addHeader("Authorization", "Bearer " + this.token.getAccessToken()).build();
        return chain.proceed(request);
    }

    protected boolean needToRefresh() {
        return this.oAuth2Client != null && Instant.now().plusSeconds(60L).isAfter(this.token.getExpiresAt());
    }

    public static OAuth2AuthInterceptor createAuthFromToken(String token) {
        OAuth2Token oAuthToken = new OAuth2Token();
        oAuthToken.setAccessToken(token);
        return new OAuth2AuthInterceptor(oAuthToken, null);
    }

    public static OAuth2AuthInterceptor obtainAuthFromAuthorizationCode(String baseUrl, String clientId, String code) {
        return OAuth2AuthInterceptor.obtainAuthFromAuthorizationCode(baseUrl, clientId, null, code);
    }

    public static OAuth2AuthInterceptor obtainAuthFromAuthorizationCode(String baseUrl, String clientId, String clientSecret, String code) {
        OAuth2Client oAuth2Client = new OAuth2Client(baseUrl, clientId, clientSecret);
        OAuth2Token token = oAuth2Client.fetchAccessTokenFromAuthenticationCode(code);
        return new OAuth2AuthInterceptor(token, oAuth2Client);
    }

    public static OAuth2AuthInterceptor obtainAuthFromJWTToken(String baseUrl, String clientId, String jwtToken) {
        return OAuth2AuthInterceptor.obtainAuthFromJWTToken(baseUrl, clientId, null, jwtToken);
    }

    public static OAuth2AuthInterceptor obtainAuthFromJWTToken(String baseUrl, String clientId, String clientSecret, String jwtToken) {
        OAuth2Client oAuth2Client = new OAuth2Client(baseUrl, clientId, clientSecret);
        OAuth2Token token = oAuth2Client.fetchAccessTokenFromJWT(jwtToken);
        return new OAuth2AuthInterceptor(token, oAuth2Client);
    }
}

