/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.spi.auth.oauth2;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.client.spi.NuxeoClientException;
import org.nuxeo.client.spi.NuxeoClientRemoteException;
import org.nuxeo.client.spi.auth.oauth2.OAuth2Token;

public class OAuth2Client {
    public static final String OAUTH_2_TOKEN_ENDPOINT = "oauth2/token";
    public static final String CLIENT_ID = "client_id";
    public static final String CLIENT_SECRET = "client_secret";
    public static final String GRANT_TYPE = "grant_type";
    public static final String GRANT_AUTHORIZATION_CODE = "authorization_code";
    public static final String AUTHENTICATION_CODE = "code";
    public static final String GRAND_JWT_BEARER = "urn:ietf:params:oauth:grant-type:jwt-bearer";
    public static final String ASSERTION = "assertion";
    public static final String GRANT_REFRESH_TOKEN = "refresh_token";
    public static final String REFRESH_TOKEN = "refresh_token";
    protected static final OkHttpClient CLIENT = new OkHttpClient.Builder().build();
    protected static final ObjectMapper MAPPER = new ObjectMapper();
    protected final String baseUrl;
    protected final String clientId;
    protected final String clientSecret;

    public OAuth2Client(String baseUrl, String clientId, String clientSecret) {
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public OAuth2Token fetchAccessTokenFromAuthenticationCode(String code) {
        FormBody.Builder builder = this.initFormBodyBuilder(GRANT_AUTHORIZATION_CODE).add(AUTHENTICATION_CODE, code);
        FormBody formBody = builder.build();
        return this.executeRequest((RequestBody)formBody);
    }

    public OAuth2Token fetchAccessTokenFromJWT(String jwtToken) {
        FormBody.Builder builder = this.initFormBodyBuilder(GRAND_JWT_BEARER).add(ASSERTION, jwtToken);
        FormBody formBody = builder.build();
        return this.executeRequest((RequestBody)formBody);
    }

    public OAuth2Token refreshToken(OAuth2Token token) {
        FormBody.Builder builder = this.initFormBodyBuilder("refresh_token").add("refresh_token", token.getRefreshToken());
        FormBody formBody = builder.build();
        return this.executeRequest((RequestBody)formBody);
    }

    protected FormBody.Builder initFormBodyBuilder(String grantType) {
        FormBody.Builder builder = new FormBody.Builder(StandardCharsets.UTF_8).add(CLIENT_ID, this.clientId);
        if (this.clientSecret != null) {
            builder.add(CLIENT_SECRET, this.clientSecret);
        }
        return builder.add(GRANT_TYPE, grantType);
    }

    protected OAuth2Token executeRequest(RequestBody body) {
        OAuth2Token oAuth2Token;
        block9: {
            Request request = new Request.Builder().url(this.baseUrl + OAUTH_2_TOKEN_ENDPOINT).post(body).build();
            Response response = CLIENT.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    String errorBody = response.body().string();
                    Map errorMap = (Map)MAPPER.readValue(errorBody, Map.class);
                    String errorMessage = (String)StringUtils.defaultIfBlank((CharSequence)response.message(), (CharSequence)((Serializable)errorMap.get("error")).toString());
                    throw new NuxeoClientRemoteException(response.code(), errorMessage, errorBody, null);
                }
                oAuth2Token = (OAuth2Token)MAPPER.readValue(response.body().charStream(), OAuth2Token.class);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new NuxeoClientException("Error during call to Nuxeo server", e);
                }
            }
            response.close();
        }
        return oAuth2Token;
    }
}

