/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.casefolder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.casefolder.CaseFolder;
import org.nuxeo.cm.casefolder.CaseFolderConstants;
import org.nuxeo.cm.casefolder.ParticipantListImpl;
import org.nuxeo.cm.casefolder.ParticipantsList;
import org.nuxeo.cm.exception.CaseManagementException;
import org.nuxeo.cm.exception.CaseManagementRuntimeException;
import org.nuxeo.cm.service.synchronization.CaseFolderSynchronizationConstants;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseFolderImpl
implements CaseFolder {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CaseFolder.class);
    protected final DocumentModel doc;

    public CaseFolderImpl(DocumentModel doc) {
        this.doc = doc;
    }

    @Override
    public DocumentModel getDocument() {
        return this.doc;
    }

    protected String getStringProperty(String property) {
        try {
            return (String)((Object)this.doc.getPropertyValue(property));
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected List<String> getStringListProperty(String property) {
        try {
            List<String> res = null;
            Serializable propValue = this.doc.getPropertyValue(property);
            if (propValue instanceof List) {
                res = (List<String>)((Object)propValue);
            } else if (propValue instanceof String[]) {
                res = Arrays.asList((String[])propValue);
            } else if (propValue != null) {
                throw new ClientRuntimeException(String.format("Unexpected non-list value for prop %s: %s", property, propValue));
            }
            return res;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected Integer getIntegerProperty(String property) {
        try {
            Serializable value = this.doc.getPropertyValue(property);
            if (value instanceof Long) {
                return Integer.valueOf(((Long)value).toString());
            }
            return null;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected Calendar getDateProperty(String property) {
        try {
            return (Calendar)this.doc.getPropertyValue(property);
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException(e);
        }
    }

    protected void setPropertyValue(String property, Serializable value) {
        try {
            this.doc.setPropertyValue(property, value);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public ParticipantsList getParticipantListTemplate() {
        try {
            Type type2;
            Object value = null;
            Property prop = this.doc.getProperty("csfd:participantlists");
            Field field = prop.getField();
            if (field != null && (type2 = field.getType()).isListType()) {
                Type itemType = ((ListType)type2).getFieldType();
                value = itemType.newInstance();
            }
            if (!(value instanceof Map)) {
                throw new ClientRuntimeException("Cannot get default template for mailing list");
            }
            Map map = (Map)value;
            return new ParticipantListImpl(map);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public void addParticipantList(ParticipantsList ml) {
        try {
            ArrayList<Map<String, Serializable>> mls = new ArrayList<Map<String, Serializable>>();
            List mailinglists = (List)((Object)this.doc.getPropertyValue("csfd:participantlists"));
            if (mailinglists != null) {
                mls.addAll(mailinglists);
            }
            mls.add(ml.getMap());
            this.setPropertyValue("csfd:participantlists", mls);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public List<String> getUsers() {
        return this.getStringListProperty("csfd:users");
    }

    @Override
    public String getDescription() {
        return this.getStringProperty("dc:description");
    }

    @Override
    public List<String> getFavorites() throws CaseManagementException {
        return this.getStringListProperty("csfd:favorites");
    }

    @Override
    public List<String> getGroups() {
        return this.getStringListProperty("csfd:groups");
    }

    @Override
    public String getId() {
        return this.getStringProperty("csfd:case_folder_id");
    }

    @Override
    public void setId(String id) {
        this.setPropertyValue("csfd:case_folder_id", (Serializable)((Object)id));
    }

    @Override
    public List<String> getParticipantListIds() {
        ArrayList<String> mlids = new ArrayList<String>();
        List<ParticipantsList> mls = this.getParticipantLists();
        if (mls != null) {
            for (ParticipantsList ml : mls) {
                mlids.add(ml.getId());
            }
        }
        return mlids;
    }

    @Override
    public List<ParticipantsList> getParticipantLists() {
        try {
            ArrayList<ParticipantsList> mls = new ArrayList<ParticipantsList>();
            List mailinglists = (List)((Object)this.doc.getPropertyValue("csfd:participantlists"));
            if (mailinglists != null) {
                for (Map mailinglist : mailinglists) {
                    mls.add(new ParticipantListImpl(mailinglist));
                }
            }
            return mls;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public List<String> getNotifiedUsers() {
        return this.getStringListProperty("csfd:notified_users");
    }

    @Override
    public String getOwner() {
        return this.getStringProperty("csfd:owner");
    }

    @Override
    public List<String> getProfiles() {
        return this.getStringListProperty("csfd:profiles");
    }

    @Override
    public String getTitle() {
        return this.getStringProperty("dc:title");
    }

    @Override
    public String getType() {
        return this.getStringProperty("csfd:type");
    }

    @Override
    public List<String> getAllUsers() {
        String owner;
        ArrayList<String> delegates = new ArrayList<String>();
        List<String> users = this.getUsers();
        if (users != null) {
            delegates.addAll(users);
        }
        if ((owner = this.getOwner()) != null && !delegates.contains(owner)) {
            delegates.add(0, owner);
        }
        return delegates;
    }

    @Override
    public boolean hasProfile(String profile) {
        List<String> profiles = this.getProfiles();
        return profiles != null && profiles.contains(profile);
    }

    @Override
    public void removeParticipantList(String mailingListId) {
        try {
            boolean set = false;
            ArrayList<Map> mls = new ArrayList<Map>();
            List mailinglists = (List)((Object)this.doc.getPropertyValue("csfd:participantlists"));
            if (mailinglists != null) {
                for (Map ml : mailinglists) {
                    if (mailingListId.equals(ml.get("plid"))) {
                        set = true;
                        continue;
                    }
                    mls.add(ml);
                }
            }
            if (set) {
                this.setPropertyValue("csfd:participantlists", mls);
            }
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public void setUsers(List<String> users) {
        ArrayList<String> serializableUsers = new ArrayList<String>();
        if (users != null) {
            serializableUsers.addAll(users);
        }
        this.setPropertyValue("csfd:users", serializableUsers);
    }

    @Override
    public void setDescription(String description) {
        this.setPropertyValue("dc:description", (Serializable)((Object)description));
    }

    @Override
    public void setFavorites(List<String> favorites) throws CaseManagementException {
        ArrayList<String> serializableFavorites = new ArrayList<String>();
        if (favorites != null) {
            serializableFavorites.addAll(favorites);
        }
        this.setPropertyValue("csfd:favorites", serializableFavorites);
    }

    @Override
    public void setGroups(List<String> groups) {
        ArrayList<String> serializableGroups = new ArrayList<String>();
        if (groups != null) {
            serializableGroups.addAll(groups);
        }
        this.setPropertyValue("csfd:groups", serializableGroups);
    }

    @Override
    public void setNotifiedUsers(List<String> users) {
        ArrayList<String> serializableUsers = new ArrayList<String>();
        if (users != null) {
            serializableUsers.addAll(users);
        }
        this.setPropertyValue("csfd:notified_users", serializableUsers);
    }

    @Override
    public void setOwner(String owner) {
        this.setPropertyValue("csfd:owner", (Serializable)((Object)owner));
    }

    @Override
    public void setProfiles(List<String> profiles) {
        ArrayList<String> serializableProfiles = new ArrayList<String>();
        if (profiles != null) {
            serializableProfiles.addAll(profiles);
        }
        this.setPropertyValue("csfd:profiles", serializableProfiles);
    }

    @Override
    public void setTitle(String title) {
        this.setPropertyValue("dc:title", (Serializable)((Object)title));
    }

    @Override
    public void setType(String type2) {
        this.setPropertyValue("csfd:type", (Serializable)((Object)type2));
    }

    @Override
    public void setConfidentiality(Integer confidentiality) {
        this.setPropertyValue("csfd:defaultconfidentiality", confidentiality);
    }

    @Override
    public Integer getConfidentiality() {
        return this.getIntegerProperty("csfd:defaultconfidentiality");
    }

    @Override
    public int compareTo(CaseFolder other) {
        if (this.getType().equals(other.getType())) {
            return this.getTitle().compareTo(other.getTitle());
        }
        if (CaseFolderConstants.type.personal.name().equals(this.getType())) {
            return -1;
        }
        return 1;
    }

    @Override
    public void save(CoreSession session) {
        try {
            session.saveDocument(this.doc);
            session.save();
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException(e);
        }
    }

    @Override
    public String getParentId(CoreSession session) {
        try {
            DocumentModel parent;
            CaseFolder parentMailbox;
            if (session.hasPermission(this.doc.getParentRef(), "Read") && (parentMailbox = (CaseFolder)(parent = session.getDocument(this.doc.getParentRef())).getAdapter(CaseFolder.class)) != null) {
                return parentMailbox.getId();
            }
        }
        catch (ClientException e) {
            log.error((Object)"Unable to retrieve parent case folder id", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<String> getChildrenIds(CoreSession session) {
        ArrayList<String> res = new ArrayList<String>();
        try {
            DocumentModelList children;
            if (session.hasPermission(this.doc.getRef(), "ReadChildren") && (children = session.getChildren(this.doc.getRef())) != null) {
                for (DocumentModel child : children) {
                    CaseFolder childCaseFolder = (CaseFolder)child.getAdapter(CaseFolder.class);
                    if (childCaseFolder == null) continue;
                    res.add(childCaseFolder.getId());
                }
            }
        }
        catch (ClientException e) {
            log.error((Object)"Unable to retrieve child case folder ids", (Throwable)e);
        }
        return res;
    }

    @Override
    public List<String> getAllUsersAndGroups() {
        List<String> groups;
        ArrayList<String> total = new ArrayList<String>();
        List<String> users = this.getAllUsers();
        if (users != null) {
            total.addAll(users);
        }
        if ((groups = this.getGroups()) != null) {
            total.addAll(groups);
        }
        return total;
    }

    @Override
    public String getAffiliatedCaseFolderId() {
        return this.getStringProperty("csfd:affiliated_case_folder_id");
    }

    @Override
    public String getSynchronizeState() {
        return this.getStringProperty("csfd:synchronizedState");
    }

    @Override
    public void setSynchronizeState(String state) {
        this.setPropertyValue("csfd:synchronizedState", (Serializable)((Object)state));
    }

    @Override
    public Boolean isSynchronized() {
        if (CaseFolderSynchronizationConstants.synchronisedState.synchronised.toString().equals(this.getSynchronizeState())) {
            return true;
        }
        return false;
    }

    @Override
    public String getSynchronizerId() {
        return this.getStringProperty("csfd:synchronizerId");
    }

    @Override
    public void setSynchronizerId(String synchronizerId) {
        this.setPropertyValue("csfd:synchronizerId", (Serializable)((Object)synchronizerId));
    }

    @Override
    public Calendar getLastSyncUpdate() {
        return this.getDateProperty("csfd:lastSyncUpdate");
    }

    @Override
    public void setLastSyncUpdate(Calendar now) {
        this.setPropertyValue("csfd:lastSyncUpdate", now);
    }

    @Override
    public String getOrigin() {
        return this.getStringProperty("csfd:origin");
    }

    @Override
    public void setOrigin(String origin) {
        this.setPropertyValue("csfd:origin", (Serializable)((Object)origin));
    }
}

