/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.cases;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.cases.CaseItem;
import org.nuxeo.cm.cases.HasParticipants;
import org.nuxeo.cm.exception.CaseManagementRuntimeException;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseImpl
implements Case {
    private static final long serialVersionUID = 6160682333116646611L;
    boolean firstDocumentFlag;
    Boolean incoming;
    protected final DocumentModel document;
    protected final HasParticipants recipientsAdapter;

    public CaseImpl(DocumentModel envelope, HasParticipants recipientsAdapter) {
        this.document = envelope;
        this.recipientsAdapter = recipientsAdapter;
    }

    @Override
    public DocumentModel getDocument() {
        return this.document;
    }

    @Override
    public List<CaseItem> getCaseItems(CoreSession session) {
        return Collections.unmodifiableList(this.getItems(session));
    }

    protected List<CaseItem> getItems(CoreSession session) {
        ArrayList<CaseItem> items = new ArrayList<CaseItem>();
        try {
            for (String emailId : this.getItemsId()) {
                DocumentModel mailDocument = session.getDocument((DocumentRef)new IdRef(emailId));
                CaseItem item = (CaseItem)mailDocument.getAdapter(CaseItem.class);
                items.add(item);
            }
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException(e);
        }
        return items;
    }

    protected List<String> getItemsId() {
        List emailIds;
        try {
            emailIds = (List)this.document.getProperty("case", "documentsId");
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException(e);
        }
        if (emailIds == null) {
            return new ArrayList<String>();
        }
        return emailIds;
    }

    @Override
    public CaseItem getFirstItem(CoreSession session) {
        DocumentModel firstItem;
        List<String> itemIds = this.getItemsId();
        if (itemIds == null || itemIds.isEmpty()) {
            return null;
        }
        String id = itemIds.get(0);
        try {
            firstItem = session.getDocument((DocumentRef)new IdRef(id));
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException(e);
        }
        if (firstItem == null) {
            return null;
        }
        return (CaseItem)firstItem.getAdapter(CaseItem.class);
    }

    @Override
    public boolean addCaseItem(CaseItem item, CoreSession session) {
        String newId;
        List<String> itemsId = this.getItemsId();
        if (itemsId.contains(newId = item.getDocument().getId())) {
            return false;
        }
        itemsId.add(newId);
        this.saveItemsId(session, itemsId);
        return true;
    }

    protected void saveItemsId(CoreSession session, List<String> itemsId) {
        try {
            this.document.setProperty("case", "documentsId", itemsId);
            session.saveDocument(this.document);
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException(e);
        }
    }

    @Override
    public boolean removeCaseItem(CaseItem item, CoreSession session) {
        List<String> itemsId = this.getItemsId();
        String newId = item.getDocument().getId();
        boolean result = itemsId.remove(newId);
        this.saveItemsId(session, itemsId);
        return result;
    }

    protected boolean moveEmailsInEnvelope(List<CaseItem> selected, boolean up, CoreSession session) {
        List<String> itemIds = this.getItemsId();
        boolean res = true;
        int size = itemIds.size();
        for (CaseItem item : selected) {
            String itemId = item.getDocument().getId();
            int index = itemIds.indexOf(itemId);
            if (index != -1) {
                if (up) {
                    if (index != 0) {
                        itemIds.remove(index);
                        itemIds.add(index - 1, itemId);
                        continue;
                    }
                    res = false;
                    continue;
                }
                if (index != size - 1) {
                    itemIds.remove(index);
                    itemIds.add(index + 1, itemId);
                    continue;
                }
                res = false;
                continue;
            }
            res = false;
        }
        this.saveItemsId(session, itemIds);
        return res;
    }

    @Override
    public boolean moveUpEmailsInCase(List<CaseItem> selected, CoreSession session) {
        return this.moveEmailsInEnvelope(selected, true, session);
    }

    @Override
    public boolean moveDownEmailsInCase(List<CaseItem> selected, CoreSession session) {
        return this.moveEmailsInEnvelope(selected, false, session);
    }

    @Override
    public void save(CoreSession session) {
        try {
            session.saveDocument(this.document);
            session.save();
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException(e);
        }
    }

    @Override
    public List<DocumentModel> getDocuments() {
        List<DocumentModel> result;
        CoreSession session = this.getDocumentSession();
        if (session == null) {
            try {
                session = this.getCoreSession();
            }
            catch (Exception e) {
                throw new CaseManagementRuntimeException(e);
            }
            result = this.getDocuments(session);
            CoreInstance.getInstance().close(session);
        } else {
            result = this.getDocuments(session);
        }
        return result;
    }

    @Override
    public List<DocumentModel> getDocuments(CoreSession session) {
        ArrayList<DocumentModel> result = new ArrayList<DocumentModel>();
        for (CaseItem item : this.getItems(session)) {
            result.add(item.getDocument());
        }
        return result;
    }

    protected CoreSession getDocumentSession() {
        CoreSession session = CoreInstance.getInstance().getSession(this.document.getSessionId());
        if (session == null) {
            // empty if block
        }
        return session;
    }

    protected CoreSession getCoreSession() throws Exception {
        RepositoryManager mgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
        if (mgr == null) {
            throw new ClientException("Cannot find RepostoryManager");
        }
        Repository repo = mgr.getRepository(this.document.getRepositoryName());
        return repo.open();
    }

    @Override
    public boolean isDraft() throws ClientException {
        return "draft".equals(this.document.getCurrentLifeCycleState());
    }

    @Override
    public void addInitialExternalParticipants(Map<String, List<String>> recipients) {
        this.recipientsAdapter.addInitialExternalParticipants(recipients);
    }

    @Override
    public void addInitialInternalParticipants(Map<String, List<String>> recipients) {
        this.recipientsAdapter.addInitialInternalParticipants(recipients);
    }

    @Override
    public void addParticipants(Map<String, List<String>> recipients) {
        this.recipientsAdapter.addParticipants(recipients);
    }

    @Override
    public Map<String, List<String>> getAllParticipants() {
        return this.recipientsAdapter.getAllParticipants();
    }

    @Override
    public Map<String, List<String>> getInitialExternalParticipants() {
        return this.recipientsAdapter.getInitialExternalParticipants();
    }

    @Override
    public Map<String, List<String>> getInitialInternalParticipants() {
        return this.recipientsAdapter.getInitialInternalParticipants();
    }
}

