/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.cases;

import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.cases.CaseItem;
import org.nuxeo.cm.cases.HasParticipants;
import org.nuxeo.cm.exception.CaseManagementRuntimeException;
import org.nuxeo.cm.service.CaseManagementDocumentTypeService;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseItemImpl
implements CaseItem {
    private static final long serialVersionUID = 1L;
    protected Case envelope;
    protected final HasParticipants recipientAdapter;
    protected final DocumentModel document;

    public CaseItemImpl(DocumentModel document, HasParticipants recipientAdapter) {
        this.document = document;
        this.recipientAdapter = recipientAdapter;
    }

    @Override
    public DocumentModel getDocument() {
        return this.document;
    }

    @Override
    public String getConfidentiality() {
        return this.getStringProperty("case_item", "confidentiality");
    }

    protected String getStringProperty(String schema, String value) {
        try {
            return (String)this.document.getProperty(schema, value);
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException(e);
        }
    }

    protected void setProperty(String schema, String property, Object value) {
        try {
            this.document.setProperty(schema, property, value);
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException(e);
        }
    }

    @Override
    public String getTitle() {
        try {
            return (String)((Object)this.document.getPropertyValue("dc:title"));
        }
        catch (PropertyException e) {
            throw new CaseManagementRuntimeException(e);
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException(e);
        }
    }

    @Override
    public void setTitle(String title) {
        try {
            this.document.setPropertyValue("dc:title", (Serializable)((Object)title));
        }
        catch (PropertyException e) {
            throw new CaseManagementRuntimeException(e);
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException(e);
        }
    }

    protected Calendar getDateProperty(String schema, String value) {
        try {
            return (Calendar)this.document.getProperty(schema, value);
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException(e);
        }
    }

    @Override
    public String getDefaultCaseId() {
        return this.getStringProperty("case_item", "defaultCaseId");
    }

    @Override
    public Calendar getDocumentDate() {
        return this.getDateProperty("case_item", "document_date");
    }

    @Override
    public Case getCase() {
        return this.envelope;
    }

    @Override
    public Calendar getImportDate() {
        return this.getDateProperty("case_item", "import_date");
    }

    @Override
    public String getOrigin() {
        return this.getStringProperty("case_item", "origin");
    }

    @Override
    public Calendar getReceiveDate() {
        return this.getDateProperty("case_item", "receive_date");
    }

    @Override
    public Calendar getSendingDate() {
        return this.getDateProperty("case_item", "sending_date");
    }

    @Override
    public String getType() {
        return this.document.getType();
    }

    @Override
    public void setConfidentiality(String cdf) {
        this.setProperty("case_item", "confidentiality", cdf);
    }

    @Override
    public void setDefaultCase(String mailEnvelopeId) {
        this.setProperty("case_item", "defaultCaseId", mailEnvelopeId);
    }

    @Override
    public void setDocumentDate(Calendar date) {
        this.setProperty("case_item", "document_date", date);
    }

    @Override
    public void setCase(Case envelope) {
        this.envelope = envelope;
    }

    @Override
    public void setImportDate(Calendar date) {
        this.setProperty("case_item", "import_date", date);
    }

    @Override
    public void setOrigin(String origin) {
        this.setProperty("case_item", "origin", origin);
    }

    @Override
    public void setReceiveDate(Calendar date) {
        this.setProperty("case_item", "receive_date", date);
    }

    @Override
    public void setSendingDate(Calendar date) {
        this.setProperty("case_item", "sending_date", date);
    }

    @Override
    public void setType(String type2) {
        this.setProperty("case_item", "CaseItem", type2);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CaseItemImpl)) {
            return false;
        }
        CaseItemImpl otherItem = (CaseItemImpl)other;
        return this.document.equals(otherItem.document);
    }

    @Override
    public void save(CoreSession session) {
        try {
            session.saveDocument(this.document);
            session.save();
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException(e);
        }
    }

    @Override
    public Case createMailCase(CoreSession session, String parentPath, String initialLifeCycleState) {
        try {
            String emailTitle = this.getTitle();
            String envelopeid = IdUtils.generateId((String)(emailTitle == null ? "" : emailTitle));
            Case mailEnvelope = this.createEnvelope(session, parentPath, envelopeid, initialLifeCycleState);
            mailEnvelope.addCaseItem((CaseItem)this.document.getAdapter(CaseItem.class), session);
            mailEnvelope.save(session);
            return mailEnvelope;
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException(e);
        }
    }

    protected Case createEnvelope(CoreSession session, String parentPath, String id, String initialLifeCycleState) throws ClientException {
        CaseManagementDocumentTypeService correspDocumentTypeService;
        try {
            correspDocumentTypeService = (CaseManagementDocumentTypeService)Framework.getService(CaseManagementDocumentTypeService.class);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        DocumentModel envelope = session.createDocumentModel(parentPath, id, correspDocumentTypeService.getCaseType());
        envelope.setPropertyValue("dc:title", this.document.getPropertyValue("dc:title"));
        envelope.putContextData("initialLifecycleState", (Serializable)((Object)initialLifeCycleState));
        envelope = session.createDocument(envelope);
        return (Case)envelope.getAdapter(Case.class);
    }

    public String toString() {
        return this.document.toString();
    }

    @Override
    public void addInitialExternalParticipants(Map<String, List<String>> recipients) {
        this.recipientAdapter.addInitialExternalParticipants(recipients);
    }

    @Override
    public void addInitialInternalParticipants(Map<String, List<String>> recipients) {
        this.recipientAdapter.addInitialInternalParticipants(recipients);
    }

    @Override
    public void addParticipants(Map<String, List<String>> recipients) {
        this.recipientAdapter.addParticipants(recipients);
    }

    @Override
    public Map<String, List<String>> getAllParticipants() {
        return this.recipientAdapter.getAllParticipants();
    }

    @Override
    public Map<String, List<String>> getInitialExternalParticipants() {
        return this.recipientAdapter.getInitialExternalParticipants();
    }

    @Override
    public Map<String, List<String>> getInitialInternalParticipants() {
        return this.recipientAdapter.getInitialInternalParticipants();
    }
}

