/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.cases;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.cm.casefolder.CaseFolder;
import org.nuxeo.cm.cases.HasParticipants;
import org.nuxeo.cm.exception.CaseManagementException;
import org.nuxeo.cm.exception.CaseManagementRuntimeException;
import org.nuxeo.cm.service.CaseManagementDistributionTypeService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HasParticipantsImpl
implements HasParticipants {
    private static final long serialVersionUID = 1L;
    protected DocumentModel document;
    protected CaseManagementDistributionTypeService distributionType;

    public HasParticipantsImpl(DocumentModel document) {
        this.document = document;
        try {
            this.distributionType = (CaseManagementDistributionTypeService)Framework.getService(CaseManagementDistributionTypeService.class);
        }
        catch (Exception e) {
            throw new CaseManagementRuntimeException(e);
        }
    }

    @Override
    public void addInitialInternalParticipants(Map<String, List<String>> recipients) {
        if (recipients == null) {
            return;
        }
        for (String key : recipients.keySet()) {
            try {
                String schemaProperty = this.distributionType.getInternalProperty(key);
                this.addRecipients(recipients.get(key), schemaProperty);
            }
            catch (CaseManagementException e) {
                throw new CaseManagementRuntimeException((Throwable)((Object)e));
            }
        }
    }

    @Override
    public void addInitialExternalParticipants(Map<String, List<String>> recipients) {
        if (recipients == null) {
            return;
        }
        for (String key : recipients.keySet()) {
            try {
                String schemaProperty = this.distributionType.getExternalProperty(key);
                this.addRecipients(recipients.get(key), schemaProperty);
            }
            catch (CaseManagementException e) {
                throw new CaseManagementRuntimeException((Throwable)((Object)e));
            }
        }
    }

    @Override
    public void addParticipants(Map<String, List<String>> recipients) {
        if (recipients == null) {
            return;
        }
        for (String key : recipients.keySet()) {
            try {
                String schemaProperty = this.distributionType.getAllProperty(key);
                this.addRecipients(recipients.get(key), schemaProperty);
            }
            catch (CaseManagementException e) {
                throw new CaseManagementRuntimeException((Throwable)((Object)e));
            }
        }
    }

    @Override
    public Map<String, List<String>> getAllParticipants() {
        HashMap<String, List<String>> values = new HashMap<String, List<String>>();
        for (String key : this.distributionType.getDistributionTypes()) {
            try {
                List<String> recipients = this.getRecipients(this.distributionType.getAllProperty(key));
                values.put(key, recipients);
            }
            catch (CaseManagementException e) {
                throw new CaseManagementRuntimeException((Throwable)((Object)e));
            }
        }
        return values;
    }

    @Override
    public Map<String, List<String>> getInitialInternalParticipants() {
        HashMap<String, List<String>> values = new HashMap<String, List<String>>();
        for (String key : this.distributionType.getDistributionTypes()) {
            try {
                List<String> recipients = this.getRecipients(this.distributionType.getInternalProperty(key));
                values.put(key, recipients);
            }
            catch (CaseManagementException e) {
                throw new CaseManagementRuntimeException((Throwable)((Object)e));
            }
        }
        return values;
    }

    @Override
    public Map<String, List<String>> getInitialExternalParticipants() {
        HashMap<String, List<String>> values = new HashMap<String, List<String>>();
        for (String key : this.distributionType.getDistributionTypes()) {
            try {
                List<String> recipients = this.getRecipients(this.distributionType.getExternalProperty(key));
                values.put(key, recipients);
            }
            catch (CaseManagementException e) {
                throw new CaseManagementRuntimeException((Throwable)((Object)e));
            }
        }
        return values;
    }

    protected void addRecipients(List<String> recipients, String xpath) {
        List<String> oldIds = this.getRecipients(xpath);
        if (oldIds == null) {
            oldIds = new ArrayList<String>();
        }
        for (String newId : recipients) {
            if (oldIds.contains(newId)) continue;
            oldIds.add(newId);
        }
        try {
            this.document.setPropertyValue(xpath, (Serializable)((Object)oldIds));
        }
        catch (PropertyException e) {
            throw new CaseManagementRuntimeException(e);
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException(e);
        }
    }

    protected List<String> getRecipients(String recipientsXpath) {
        List recipients = null;
        try {
            recipients = (List)((Object)this.document.getPropertyValue(recipientsXpath));
        }
        catch (PropertyException e) {
            throw new CaseManagementRuntimeException(e);
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException(e);
        }
        return recipients;
    }

    protected List<String> getCaseFolderIds(List<CaseFolder> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (CaseFolder mailbox : list) {
            result.add(mailbox.getId());
        }
        return result;
    }
}

