/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.cases;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.cases.LockableAdapter;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockableAdapterImpl
implements LockableAdapter {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(LockableAdapterImpl.class);
    protected final DocumentModel document;

    public LockableAdapterImpl(DocumentModel document) {
        this.document = document;
    }

    @Override
    public Map<String, String> lockDocument(CoreSession documentManager) throws ClientException {
        StringBuilder result = new StringBuilder();
        result.append(documentManager.getPrincipal().getName()).append(':').append(DateFormat.getDateInstance(2).format(new Date()));
        String lockKey = result.toString();
        this.document.setLock(lockKey);
        documentManager.save();
        return this.getDocumentLockDetails(documentManager);
    }

    @Override
    public void unlockDocument(CoreSession documentManager) throws ClientException {
        Map<String, String> lockDetails = this.getDocumentLockDetails(documentManager);
        if (lockDetails != null && !lockDetails.isEmpty()) {
            DocumentRef ref = this.document.getRef();
            NuxeoPrincipal userName = (NuxeoPrincipal)documentManager.getPrincipal();
            if (userName.isAdministrator() || documentManager.hasPermission(ref, "Everything") || userName.getName().equals(lockDetails.get("LockActions.LOCKER"))) {
                if (documentManager.hasPermission(ref, "WriteProperties")) {
                    this.document.unlock();
                    documentManager.save();
                } else {
                    log.error((Object)("Cannot unlock document " + this.document.getName()));
                }
            }
        }
    }

    @Override
    public boolean isLocked(CoreSession documentManager) throws ClientException {
        Map<String, String> lockDetails = this.getDocumentLockDetails(documentManager);
        if (lockDetails != null && !lockDetails.isEmpty()) {
            NuxeoPrincipal userName = (NuxeoPrincipal)documentManager.getPrincipal();
            return !userName.getName().equals(lockDetails.get("LockActions.LOCKER"));
        }
        return false;
    }

    @Override
    public boolean isLockedByCurrentUser(CoreSession documentManager) throws ClientException {
        NuxeoPrincipal userName;
        Map<String, String> lockDetails = this.getDocumentLockDetails(documentManager);
        return lockDetails != null && !lockDetails.isEmpty() && (userName = (NuxeoPrincipal)documentManager.getPrincipal()).getName().equals(lockDetails.get("LockActions.LOCKER"));
    }

    @Override
    public Map<String, String> getDocumentLockDetails(CoreSession documentManager) throws ClientException {
        DocumentRef ref;
        String documentKey;
        HashMap<String, String> lockDetails = new HashMap<String, String>();
        if (this.document != null && (documentKey = documentManager.getLock(ref = this.document.getRef())) != null) {
            String[] values = documentKey.split(":");
            lockDetails.put("LockActions.LOCKER", values[0]);
            lockDetails.put("LockActions.LOCK_TIME", values[1]);
        }
        return lockDetails;
    }
}

