/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.contact;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.cm.casefolder.CaseFolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Contact
implements Serializable,
Comparable<Contact> {
    private static final CONTACT_FIELD[] FIELDS_FOR_FULLTEXT_INDEXING = new CONTACT_FIELD[]{CONTACT_FIELD.name, CONTACT_FIELD.email, CONTACT_FIELD.surname, CONTACT_FIELD.service, CONTACT_FIELD.caseFolderId};
    private static final long serialVersionUID = 1L;
    protected String name;
    protected String email;
    protected String surname;
    protected String service;
    protected String caseFolderId;

    public Contact() {
    }

    public Contact(Map<? extends String, ? extends Serializable> m) {
        if (m != null) {
            this.name = (String)((Object)m.get(CONTACT_FIELD.name.name()));
            this.email = (String)((Object)m.get(CONTACT_FIELD.email.name()));
            this.surname = (String)((Object)m.get(CONTACT_FIELD.surname.name()));
            this.service = (String)((Object)m.get(CONTACT_FIELD.service.name()));
            this.caseFolderId = (String)((Object)m.get(CONTACT_FIELD.caseFolderId.name()));
        }
    }

    public String asStringForIndexing() {
        return this.asStringFor(FIELDS_FOR_FULLTEXT_INDEXING);
    }

    private String asStringFor(CONTACT_FIELD[] fields) {
        StringBuilder sb = new StringBuilder();
        boolean empty = true;
        HashMap<String, Serializable> map = this.getContactMap();
        for (CONTACT_FIELD field : fields) {
            Serializable v = (Serializable)map.get(field.name());
            if (v == null) continue;
            if (!empty) {
                sb.append(" ");
            }
            empty = false;
            sb.append(v);
        }
        return empty ? null : sb.toString();
    }

    public HashMap<String, Serializable> getContactMap() {
        HashMap<String, Serializable> m = new HashMap<String, Serializable>();
        if (this.name != null) {
            m.put(CONTACT_FIELD.name.name(), (Serializable)((Object)this.name));
        }
        if (this.email != null) {
            m.put(CONTACT_FIELD.email.name(), (Serializable)((Object)this.email));
        }
        if (this.surname != null) {
            m.put(CONTACT_FIELD.surname.name(), (Serializable)((Object)this.surname));
        }
        if (this.service != null) {
            m.put(CONTACT_FIELD.service.name(), (Serializable)((Object)this.service));
        }
        if (this.caseFolderId != null) {
            m.put(CONTACT_FIELD.caseFolderId.name(), (Serializable)((Object)this.caseFolderId));
        }
        return m;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getCaseFolderIdd() {
        return this.caseFolderId;
    }

    public void setCaseFolderId(String caseFolderId) {
        this.caseFolderId = caseFolderId;
    }

    public String toString() {
        return this.getContactMap().toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Contact) {
            return this.compareTo((Contact)obj) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Contact other) {
        if (other == null) {
            return 1;
        }
        return this.asStringForIndexing().compareTo(other.asStringForIndexing());
    }

    public static Contact getContactForMailbox(CaseFolder caseFolder, String email, String service, String surname) {
        if (caseFolder == null) {
            return null;
        }
        Contact contact = new Contact();
        contact.caseFolderId = caseFolder.getId();
        contact.name = caseFolder.getTitle();
        contact.email = email;
        contact.service = service;
        contact.surname = surname;
        return contact;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CONTACT_FIELD {
        name,
        email,
        surname,
        service,
        caseFolderId;

    }
}

