/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.contact;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuxeo.cm.contact.Contact;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Contacts
extends ArrayList<Contact> {
    private static final long serialVersionUID = 1L;

    public Contacts() {
    }

    public Contacts(List<Map<String, Serializable>> data) {
        if (data != null) {
            for (Map<String, Serializable> item : data) {
                this.addContact(new Contact(item));
            }
        }
    }

    public static Contacts getContactsForDoc(DocumentModel doc, String propertyName) throws PropertyException {
        List data;
        try {
            data = (List)((Object)doc.getPropertyValue(propertyName));
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        return new Contacts(data);
    }

    public void addContact(Contact contact) {
        this.add(contact);
    }

    public List<Contact> getContacts() {
        return this;
    }

    public ArrayList<Map<String, Serializable>> getContactsData() {
        ArrayList<Map<String, Serializable>> res = new ArrayList<Map<String, Serializable>>();
        for (Contact contact : this) {
            res.add(contact.getContactMap());
        }
        return res;
    }

    public List<String> getEmails() {
        return this.getDatas(Contact.CONTACT_FIELD.email);
    }

    public List<String> getNames() {
        return this.getDatas(Contact.CONTACT_FIELD.name);
    }

    public List<String> getMailboxes() {
        return this.getDatas(Contact.CONTACT_FIELD.caseFolderId);
    }

    private List<String> getDatas(Contact.CONTACT_FIELD field) {
        ArrayList<String> names = new ArrayList<String>();
        for (Map<String, Serializable> contact : this.getContactsData()) {
            String name = (String)((Object)contact.get(field.name()));
            if (name == null || "".equals(name)) continue;
            names.add(name);
        }
        return names;
    }

    public String asNameEmailString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (Contact contact : this) {
            result.append(contact.getName());
            String email = contact.getEmail();
            if (email != null && !"".equals(email)) {
                result.append(" (" + email + ")");
            }
            result.append(",");
        }
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }
}

