/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.distribution;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.nuxeo.cm.caselink.CaseLinkType;
import org.nuxeo.cm.distribution.ParticipantItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributionInfo
implements Serializable {
    private static final long serialVersionUID = 6930633132089246322L;
    String mode;
    List<ParticipantItem> favoriteMailboxes;
    List<String> forActionMailboxes;
    List<String> forActionMailingLists;
    List<String> forActionGroups;
    String[] forActionFunctions;
    List<String> forInformationMailboxes;
    List<String> forInformationGroups;
    List<String> forInformationMailingLists;
    String[] forInformationFunctions;
    String comment;

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public List<ParticipantItem> getFavoriteCaseFolders() {
        return this.favoriteMailboxes;
    }

    public void setFavoriteCaseFolders(List<ParticipantItem> favoriteMailboxes) {
        this.favoriteMailboxes = favoriteMailboxes;
        Collections.sort(this.favoriteMailboxes, new Comparator<ParticipantItem>(){

            @Override
            public int compare(ParticipantItem o1, ParticipantItem o2) {
                int comp = 0;
                if (o1.getType() != null) {
                    comp = o1.getType().compareTo(o2.getType());
                } else if (o2.getType() != null) {
                    return -1;
                }
                if (comp == 0 && o1.getTitle() != null) {
                    comp = o1.getTitle().compareTo(o2.getTitle());
                }
                return comp;
            }
        });
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<String> getForActionCaseFolders() {
        return this.forActionMailboxes;
    }

    public void setForActionCaseFolders(List<String> forActionPersonalMailboxes) {
        this.forActionMailboxes = forActionPersonalMailboxes;
    }

    public List<String> getForInformationCaseFolders() {
        return this.forInformationMailboxes;
    }

    public void setForInformationCaseFolders(List<String> forInformationPersonalMailboxes) {
        this.forInformationMailboxes = forInformationPersonalMailboxes;
    }

    public void setForActionParticipantLists(List<String> forActionMailingLists) {
        this.forActionMailingLists = forActionMailingLists;
    }

    public void setForActionFunctions(String[] forActionFunctions) {
        this.forActionFunctions = forActionFunctions;
    }

    public void setForInformationParticipantLists(List<String> forInformationMailingLists) {
        this.forInformationMailingLists = forInformationMailingLists;
    }

    public void setForInformationFunctions(String[] forInformationFunctions) {
        this.forInformationFunctions = forInformationFunctions;
    }

    public List<String> getAllForActionCaseFolders() {
        String type2 = CaseLinkType.FOR_ACTION.getStringType();
        HashSet<String> mailboxes = new HashSet<String>();
        if (this.favoriteMailboxes != null && !this.favoriteMailboxes.isEmpty()) {
            for (ParticipantItem item : this.favoriteMailboxes) {
                if (!type2.equals(item.getType())) continue;
                mailboxes.add(item.getId());
            }
        }
        if (this.forActionMailboxes != null) {
            mailboxes.addAll(this.forActionMailboxes);
        }
        return new ArrayList<String>(mailboxes);
    }

    public List<String> getForActionParticipantLists() {
        return this.forActionMailingLists;
    }

    public List<String> getForActionFunctions() {
        if (this.forActionFunctions != null) {
            return Arrays.asList(this.forActionFunctions);
        }
        return null;
    }

    public List<String> getAllForInformationCaseFolders() {
        String type2 = CaseLinkType.FOR_INFORMATION.getStringType();
        HashSet<String> mailboxes = new HashSet<String>();
        if (this.favoriteMailboxes != null && !this.favoriteMailboxes.isEmpty()) {
            for (ParticipantItem item : this.favoriteMailboxes) {
                if (!type2.equals(item.getType())) continue;
                mailboxes.add(item.getId());
            }
        }
        if (this.forInformationMailboxes != null) {
            mailboxes.addAll(this.forInformationMailboxes);
        }
        return new ArrayList<String>(mailboxes);
    }

    public List<String> getForInformationParticipantLists() {
        return this.forInformationMailingLists;
    }

    public List<String> getForInformationFunctions() {
        if (this.forInformationFunctions != null) {
            return Arrays.asList(this.forInformationFunctions);
        }
        return null;
    }

    public Map<String, List<String>> getAllParticipants() {
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        res.put(CaseLinkType.FOR_ACTION.name(), this.getAllForActionCaseFolders());
        res.put(CaseLinkType.FOR_INFORMATION.name(), this.getAllForInformationCaseFolders());
        return res;
    }

    public boolean isEmpty(List list) {
        return list == null || list.isEmpty();
    }

    public boolean hasParticipants() {
        boolean res = true;
        if (this.isEmpty(this.forActionMailboxes) && this.isEmpty(this.forActionMailingLists) && this.isEmpty(this.getForActionFunctions()) && this.isEmpty(this.forActionGroups) && this.isEmpty(this.forInformationMailboxes) && this.isEmpty(this.forInformationMailingLists) && this.isEmpty(this.getForInformationFunctions()) && this.isEmpty(this.forInformationGroups)) {
            res = false;
        }
        return res;
    }

    public boolean hasActionParticipants() {
        boolean res = true;
        if (this.isEmpty(this.forActionMailboxes) && this.isEmpty(this.forActionMailingLists) && this.isEmpty(this.getForActionFunctions()) && this.isEmpty(this.forActionGroups)) {
            res = false;
        }
        return res;
    }

    public List<String> getForActionGroups() {
        return this.forActionGroups;
    }

    public void setForActionGroups(List<String> forActionGroups) {
        this.forActionGroups = forActionGroups;
    }

    public List<String> getForInformationGroups() {
        return this.forInformationGroups;
    }

    public void setForInformationGroups(List<String> forInformationGroups) {
        this.forInformationGroups = forInformationGroups;
    }
}

