/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.event;

import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.service.CaseDistributionService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.platform.mail.action.ExecutionContext;
import org.nuxeo.ecm.platform.mail.action.MessageActionPipe;
import org.nuxeo.ecm.platform.mail.action.Visitor;
import org.nuxeo.ecm.platform.mail.service.MailService;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.runtime.api.Framework;

public class MailInjectionListener
implements EventListener {
    private static final Log log = LogFactory.getLog(MailInjectionListener.class);
    private static final String INBOX = "INBOX";
    private static final String IMPORT_MAILBOX = "correspondenceImport";
    private static final String MAILBOX_PIPE = "correspondenceMailBox";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) throws ClientException {
        MailService mailService;
        try {
            mailService = (MailService)Framework.getService(MailService.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get Mailbox service.");
        }
        MessageActionPipe pipe = mailService.getPipe(MAILBOX_PIPE);
        Visitor visitor = new Visitor(pipe);
        Thread.currentThread().setContextClassLoader(Framework.class.getClassLoader());
        LoginContext loginContext = null;
        CoreSession session = null;
        Folder rootFolder = null;
        try {
            loginContext = Framework.login();
            RepositoryManager mgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
            session = mgr.getDefaultRepository().open();
            ExecutionContext initialExecutionContext = new ExecutionContext();
            initialExecutionContext.put((Object)"sessionId", (Object)session.getSessionId());
            initialExecutionContext.put((Object)"mimetypeService", Framework.getService(MimetypeRegistry.class));
            initialExecutionContext.put((Object)"correspondenceService", Framework.getService(CaseDistributionService.class));
            Store store = mailService.getConnectedStore(IMPORT_MAILBOX);
            rootFolder = store.getFolder(INBOX);
            rootFolder.open(2);
            Flags flags = new Flags();
            flags.add(Flags.Flag.SEEN);
            FlagTerm term = new FlagTerm(flags, false);
            Message[] unreadMessages = rootFolder.search((SearchTerm)term);
            visitor.visit(unreadMessages, initialExecutionContext);
            session.save();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        finally {
            if (rootFolder != null && rootFolder.isOpen()) {
                try {
                    rootFolder.close(true);
                }
                catch (MessagingException e) {}
            }
            if (loginContext != null) {
                try {
                    loginContext.logout();
                }
                catch (LoginException e) {}
            }
            if (session != null) {
                CoreInstance.getInstance().close(session);
            }
        }
    }

    protected CoreSession getCoreSession() throws Exception {
        RepositoryManager mgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
        if (mgr == null) {
            throw new ClientException("Cannot find RepostoryManager");
        }
        Repository repo = mgr.getDefaultRepository();
        return repo.open();
    }
}

