/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.mail.actionpipe;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.casefolder.CaseFolder;
import org.nuxeo.cm.caselink.CaseLinkRequestImpl;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.cases.CaseItem;
import org.nuxeo.cm.cases.CaseTreeHelper;
import org.nuxeo.cm.contact.Contact;
import org.nuxeo.cm.contact.Contacts;
import org.nuxeo.cm.distribution.DistributionInfo;
import org.nuxeo.cm.mail.actionpipe.AbstractCaseManagementMailAction;
import org.nuxeo.cm.service.CaseDistributionService;
import org.nuxeo.cm.service.CaseFolderManagementService;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.mail.action.ExecutionContext;
import org.nuxeo.runtime.api.Framework;

public class CreateAndDistributeDocuments
extends AbstractCaseManagementMailAction {
    private static final Log log = LogFactory.getLog(CreateAndDistributeDocuments.class);

    public boolean execute(ExecutionContext context) throws Exception {
        CoreSession session = this.getCoreSession(context);
        if (session == null) {
            log.error((Object)"Could not open core session");
            return false;
        }
        Calendar receptionDate = (Calendar)context.get((Object)"receptionDate");
        String subject = (String)context.get((Object)"subject");
        String messageId = (String)context.get((Object)"messageId");
        String senderEmail = (String)context.get((Object)"senderEmail");
        Contacts origSenders = (Contacts)context.get((Object)"originalSenders");
        Contacts origToRecipients = (Contacts)context.get((Object)"originalToRecipients");
        Contacts origCcRecipients = (Contacts)context.get((Object)"originalCcRecipients");
        Calendar origReceptionDate = (Calendar)context.get((Object)"originalReceptionDate");
        CaseFolderManagementService caseFolderManagemenetService = (CaseFolderManagementService)Framework.getService(CaseFolderManagementService.class);
        CaseFolder senderMailbox = caseFolderManagemenetService.getUserPersonalCaseFolderForEmail(session, senderEmail);
        if (senderMailbox == null) {
            return false;
        }
        Contact senderContact = Contact.getContactForMailbox(senderMailbox, senderEmail, null, null);
        Contacts internalOrigSenders = new Contacts();
        Contacts externalOrigSenders = new Contacts();
        this.fillContactInformation(session, caseFolderManagemenetService, origSenders, internalOrigSenders, externalOrigSenders);
        LinkedList<String> origSendersMailboxesId = new LinkedList<String>();
        origSendersMailboxesId.addAll(internalOrigSenders.getMailboxes());
        Contacts internalOrigToRecipients = new Contacts();
        Contacts externalOrigToRecipients = new Contacts();
        this.fillContactInformation(session, caseFolderManagemenetService, origToRecipients, internalOrigToRecipients, externalOrigToRecipients);
        LinkedHashSet<String> mailboxesForAction = new LinkedHashSet<String>();
        mailboxesForAction.addAll(internalOrigToRecipients.getMailboxes());
        mailboxesForAction.add(senderMailbox.getId());
        internalOrigToRecipients.add(senderContact);
        Contacts internalOrigCcRecipients = new Contacts();
        Contacts externalOrigCcRecipients = new Contacts();
        this.fillContactInformation(session, caseFolderManagemenetService, origCcRecipients, internalOrigCcRecipients, externalOrigCcRecipients);
        LinkedHashSet<String> mailboxesForInformation = new LinkedHashSet<String>();
        mailboxesForInformation.addAll(internalOrigCcRecipients.getMailboxes());
        DistributionInfo distributionInfo = new DistributionInfo();
        distributionInfo.setForActionCaseFolders(new ArrayList<String>(mailboxesForAction));
        distributionInfo.setForInformationCaseFolders(new ArrayList<String>(mailboxesForInformation));
        DocumentModel mailRootdoc = session.getDocument((DocumentRef)new PathRef("/case-management/case-root"));
        Date now = new Date();
        if (receptionDate != null) {
            now = receptionDate.getTime();
        }
        DocumentModel parent = CaseTreeHelper.getOrCreateDateTreeFolder(session, mailRootdoc, now, "Folder");
        String parentPath = parent.getPathAsString();
        List blobs = (List)context.get((Object)"attachments");
        boolean first = true;
        Case envelope = null;
        for (Blob blob : blobs) {
            String emailTitle;
            DocumentModel emailDoc = session.createDocumentModel(this.getCorrespondenceDocumentTypeToCreate());
            if (first) {
                emailTitle = subject;
            } else {
                int lastDot;
                emailTitle = blob.getFilename();
                if (emailTitle != null && (lastDot = emailTitle.lastIndexOf(".")) != -1) {
                    emailTitle = emailTitle.substring(0, lastDot);
                }
            }
            if (emailTitle == null) {
                emailTitle = "";
            }
            String docName = IdUtils.generateId((String)emailTitle);
            emailDoc.setPathInfo(parentPath, docName);
            emailDoc.setPropertyValue("dc:title", (Serializable)((Object)emailTitle));
            emailDoc.setPropertyValue("cmdoc:receive_date", (Serializable)receptionDate);
            emailDoc.setPropertyValue("cmdoc:import_date", (Serializable)origReceptionDate);
            emailDoc.setPropertyValue("cmdoc:reference", (Serializable)((Object)messageId));
            LinkedHashSet<Map<String, Serializable>> sendersContactsProperty = new LinkedHashSet<Map<String, Serializable>>();
            sendersContactsProperty.addAll(internalOrigSenders.getContactsData());
            sendersContactsProperty.addAll(externalOrigSenders.getContactsData());
            emailDoc.setPropertyValue("cmct:sendersContacts", (Serializable)sendersContactsProperty);
            if (origSendersMailboxesId != null) {
                emailDoc.setPropertyValue("cmdoc:senders", (Serializable)origSendersMailboxesId.toArray());
            }
            LinkedHashSet<Map<String, Serializable>> recipientsContactsProperty = new LinkedHashSet<Map<String, Serializable>>();
            recipientsContactsProperty.addAll(internalOrigToRecipients.getContactsData());
            recipientsContactsProperty.addAll(externalOrigToRecipients.getContactsData());
            recipientsContactsProperty.addAll(internalOrigCcRecipients.getContactsData());
            recipientsContactsProperty.addAll(externalOrigCcRecipients.getContactsData());
            if (!recipientsContactsProperty.isEmpty()) {
                emailDoc.setPropertyValue("cmct:participantsContacts", (Serializable)recipientsContactsProperty);
            }
            emailDoc.setPropertyValue("cmdoc:origin", (Serializable)((Object)"mail"));
            emailDoc.setPropertyValue("file:content", (Serializable)blob);
            emailDoc.setPropertyValue("file:filename", (Serializable)((Object)blob.getFilename()));
            emailDoc = session.createDocument(emailDoc);
            CaseItem item = (CaseItem)emailDoc.getAdapter(CaseItem.class);
            item.save(session);
            if (first) {
                envelope = item.createMailCase(session, parent.getPathAsString(), "sent");
            } else {
                envelope.addCaseItem(item, session);
            }
            first = false;
        }
        Map<String, List<String>> recipients = distributionInfo.getAllParticipants();
        CaseLinkRequestImpl postRequest = new CaseLinkRequestImpl(null, Calendar.getInstance(), (String)((Object)envelope.getDocument().getPropertyValue("dc:title")), null, envelope, recipients, null);
        CaseDistributionService service = this.getCaseDistributionService();
        service.sendCase(session, postRequest, envelope.isDraft());
        envelope.save(session);
        session.save();
        return true;
    }

    protected void fillContactInformation(CoreSession session, CaseFolderManagementService correspondenceService, Contacts originalContacts, Contacts internalContacts, Contacts externalContacts) {
        if (originalContacts != null) {
            for (Contact origContact : originalContacts) {
                String origContactEmail = origContact.getEmail();
                CaseFolder origContactMailbox = correspondenceService.getUserPersonalCaseFolderForEmail(session, origContactEmail);
                if (origContactMailbox != null) {
                    Contact newOrigSender = Contact.getContactForMailbox(origContactMailbox, origContactEmail, null, null);
                    if (internalContacts.contains(newOrigSender)) continue;
                    internalContacts.add(newOrigSender);
                    continue;
                }
                if (externalContacts.contains(origContact)) continue;
                externalContacts.add(origContact);
            }
        }
    }

    protected String getCorrespondenceDocumentTypeToCreate() {
        return "CaseItem";
    }

    public void reset(ExecutionContext context) throws Exception {
    }

    private CaseDistributionService getCaseDistributionService() throws Exception {
        CaseDistributionService distributionService = (CaseDistributionService)Framework.getService(CaseDistributionService.class);
        if (distributionService == null) {
            log.error((Object)"Unable to get the distribution service");
            throw new ClientException("Unable to get the distribution service");
        }
        return distributionService;
    }
}

