/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.mail.actionpipe;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.mail.actionpipe.AbstractCaseManagementMailAction;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.platform.mail.action.ExecutionContext;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;

public class ExtractMessageInformation
extends AbstractCaseManagementMailAction {
    private static final Log log = LogFactory.getLog(ExtractMessageInformation.class);
    public static final String DEFAULT_BINARY_MIMETYPE = "application/octet-stream*";
    public static final String MESSAGE_RFC822_MIMETYPE = "message/rfc822";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ExecutionContext context) throws Exception {
        File tmpOutput = null;
        OutputStream out = null;
        try {
            MimetypeRegistry mimeService;
            String subject;
            String[] dateHeader;
            Date receivedDate;
            Address[] from;
            Message message;
            Message originalMessage = context.getMessage();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Transforming message, original subject: " + originalMessage.getSubject()));
            }
            if (originalMessage instanceof MimeMessage) {
                message = new MimeMessage((MimeMessage)originalMessage);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Transforming message after full load: " + message.getSubject()));
                }
            } else {
                message = originalMessage;
            }
            if ((from = message.getFrom()) != null) {
                Address addr = from[0];
                if (addr instanceof InternetAddress) {
                    InternetAddress iAddr = (InternetAddress)addr;
                    context.put((Object)"sender", (Object)iAddr.getPersonal());
                    context.put((Object)"senderEmail", (Object)iAddr.getAddress());
                } else {
                    context.put((Object)"sender", (Object)addr.toString());
                }
            }
            if ((receivedDate = message.getReceivedDate()) == null && (dateHeader = message.getHeader("Date")) != null) {
                try {
                    long time = Date.parse(dateHeader[0]);
                    receivedDate = new Date(time);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (receivedDate != null) {
                Calendar date = Calendar.getInstance();
                date.setTime(receivedDate);
                context.put((Object)"receptionDate", (Object)date);
            }
            if ((subject = message.getSubject()) != null) {
                subject = subject.trim();
            }
            if (subject == null || "".equals(subject)) {
                subject = "<Unknown>";
            }
            context.put((Object)"subject", (Object)subject);
            String[] messageIdHeader = message.getHeader("Message-ID");
            if (messageIdHeader != null) {
                context.put((Object)"messageId", (Object)messageIdHeader[0]);
            }
            if ((mimeService = (MimetypeRegistry)context.getInitialContext().get((Object)"mimetypeService")) == null) {
                log.error((Object)"Could not retrieve mimetype service");
            }
            tmpOutput = File.createTempFile("injectedEmail", ".eml");
            out = new FileOutputStream(tmpOutput);
            message.writeTo(out);
            FileBlob fileBlob = new FileBlob(tmpOutput);
            fileBlob.setFilename(subject + ".eml");
            fileBlob.setMimeType(MESSAGE_RFC822_MIMETYPE);
            ArrayList<FileBlob> blobs = new ArrayList<FileBlob>();
            blobs.add(fileBlob);
            context.put((Object)"attachments", blobs);
            ExtractMessageInformation.getAttachmentParts((Part)message, subject, mimeService, context);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (tmpOutput != null) {
                tmpOutput.deleteOnExit();
            }
        }
        return false;
    }

    protected static String getFilename(Part p, String defaultFileName) throws Exception {
        String originalFilename = p.getFileName();
        if (originalFilename == null || originalFilename.trim().length() == 0) {
            String filename = defaultFileName;
            if (p.isMimeType("text/plain")) {
                filename = filename + ".txt";
            } else if (p.isMimeType("text/html")) {
                filename = filename + ".html";
            }
            return filename;
        }
        try {
            return MimeUtility.decodeText((String)originalFilename.trim());
        }
        catch (Exception e) {
            return originalFilename.trim();
        }
    }

    protected static void getAttachmentParts(Part p, String defaultFilename, MimetypeRegistry mimeService, ExecutionContext context) throws Exception {
        String filename = ExtractMessageInformation.getFilename(p, defaultFilename);
        List blobs = (List)context.get((Object)"attachments");
        if (!p.isMimeType("multipart/*")) {
            String disp = p.getDisposition();
            if (disp == null && !context.containsKey((Object)"body")) {
                context.put((Object)"body", p.getContent());
            } else if (disp != null && (disp.equalsIgnoreCase("attachment") || disp.equalsIgnoreCase("inline") && !p.isMimeType("text/*") && !p.isMimeType("image/*"))) {
                log.debug((Object)("Saving attachment to file " + filename));
                FileBlob fileBlob = new FileBlob(p.getInputStream());
                String mime = DEFAULT_BINARY_MIMETYPE;
                try {
                    if (mimeService != null) {
                        ContentType contentType = new ContentType(p.getContentType());
                        mime = mimeService.getMimetypeFromFilenameAndBlobWithDefault(filename, (Blob)fileBlob, contentType.getBaseType());
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
                fileBlob.setMimeType(mime);
                fileBlob.setFilename(filename);
                blobs.add(fileBlob);
                log.debug((Object)"---------------------------");
            } else {
                log.debug((Object)String.format("Ignoring part with type %s", p.getContentType()));
            }
        }
        if (p.isMimeType("multipart/*")) {
            log.debug((Object)"This is a Multipart");
            log.debug((Object)"---------------------------");
            Multipart mp = (Multipart)p.getContent();
            int count = mp.getCount();
            for (int i = 0; i < count; ++i) {
                ExtractMessageInformation.getAttachmentParts((Part)mp.getBodyPart(i), defaultFilename, mimeService, context);
            }
        } else if (p.isMimeType(MESSAGE_RFC822_MIMETYPE)) {
            log.debug((Object)"This is a Nested Message");
            log.debug((Object)"---------------------------");
            ExtractMessageInformation.getAttachmentParts((Part)p.getContent(), defaultFilename, mimeService, context);
        }
    }

    public void reset(ExecutionContext context) throws Exception {
    }
}

