/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.mail.actionpipe;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.contact.Contact;
import org.nuxeo.cm.contact.Contacts;
import org.nuxeo.cm.mail.actionpipe.AbstractCaseManagementMailAction;
import org.nuxeo.ecm.platform.mail.action.ExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseMailBody
extends AbstractCaseManagementMailAction {
    private static final String ENGLISH_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss ZZZZZ";
    private static final String FRENCH_DATE_FORMAT = "EEEE dd MMM yyyy HH:mm";
    private static final Log log = LogFactory.getLog(ParseMailBody.class);
    public static final Integer GROUP_TO_FIND_INDEX = 2;
    public static final Pattern HEADER_PATTERN = Pattern.compile("(.*?)(De :)(.*?)(Envoy\u00e9 :)((.*?)(\u00c0 :))?((.*?)(Cc :))?(.*?)(Objet :)(.*?)");
    public static final Pattern ENGLISH_HEADER_PATTERN = Pattern.compile("(.*?)Original Message(.*?)(Subject:)(.*?)(Date:)(.*?)(From:)(.*?)(To:)(.*?)((Cc:)(.*?))?");
    public static final Pattern CONTACT_PATTERN = Pattern.compile("(.*)(\\[mailto:)(.*?)(\\])(.*)");
    public static final String EMAIL_MATCH = "^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}$";
    public static final Pattern THUNDERBIDRD_ENGLISH_CONTACT_PATTERN = Pattern.compile("(.*?)<(.*?)>(.*?)");
    public static final String TRANSFER_MARKER = " > ";
    public static final Map<String, Integer> monthMap = new HashMap<String, Integer>();

    public static final void initializeMonthMap() {
        if (monthMap.isEmpty()) {
            monthMap.put("janvier", 0);
            monthMap.put("f\u00e9vrier", 1);
            monthMap.put("mars", 2);
            monthMap.put("avril", 3);
            monthMap.put("mai", 4);
            monthMap.put("juin", 5);
            monthMap.put("juillet", 6);
            monthMap.put("ao\u00fbt", 7);
            monthMap.put("septembre", 8);
            monthMap.put("octobre", 9);
            monthMap.put("novembre", 10);
            monthMap.put("d\u00e9cembre", 11);
        }
    }

    public boolean execute(ExecutionContext context) throws Exception {
        Object content = context.get((Object)"body");
        if (content != null) {
            ParseMailBody.parse(content, (Map<String, Object>)context);
        }
        return true;
    }

    protected static boolean parseEnglishBody(Matcher m, Map<String, Object> resultMap) {
        Contacts origSenders;
        if (log.isDebugEnabled()) {
            for (int i = 1; i < m.groupCount() + 1; ++i) {
                log.debug((Object)(i + ": " + m.group(i)));
            }
        }
        if ((origSenders = ParseMailBody.parseEnglishContacts(m.group(8))) != null && !origSenders.isEmpty()) {
            String origSenderName = ((Contact)origSenders.get(0)).getName();
            resultMap.put("originalSenderName", origSenderName);
        }
        resultMap.put("originalSenders", origSenders);
        if (m.group(6) != null) {
            resultMap.put("originalReceptionDate", ParseMailBody.parseEnglishDate(m.group(6)));
        }
        if (m.group(10) != null) {
            resultMap.put("originalToRecipients", ParseMailBody.parseEnglishContacts(m.group(10)));
        }
        Contacts ccContacts = new Contacts();
        if (m.group(13) != null) {
            ccContacts = ParseMailBody.parseEnglishContacts(m.group(13));
        }
        resultMap.put("originalCcRecipients", ccContacts);
        return true;
    }

    protected static boolean parseFrenchBody(Matcher m, Map<String, Object> resultMap) {
        for (int i = 1; i < m.groupCount() + 1; ++i) {
            log.debug((Object)(i + ": " + m.group(i)));
        }
        Contacts origSenders = ParseMailBody.parseContacts(m.group(3));
        if (origSenders != null && !origSenders.isEmpty()) {
            String origSenderName = ((Contact)origSenders.get(0)).getName();
            resultMap.put("originalSenderName", origSenderName);
        }
        resultMap.put("originalSenders", origSenders);
        if (m.group(6) != null) {
            resultMap.put("originalReceptionDate", ParseMailBody.parseDate(m.group(6)));
            if (m.group(8) != null) {
                resultMap.put("originalToRecipients", ParseMailBody.parseContacts(m.group(9)));
                resultMap.put("originalCcRecipients", ParseMailBody.parseContacts(m.group(11)));
            } else {
                resultMap.put("originalToRecipients", ParseMailBody.parseContacts(m.group(11)));
            }
        } else {
            resultMap.put("originalReceptionDate", ParseMailBody.parseDate(m.group(11)));
        }
        return true;
    }

    public static void parse(Object content, Map<String, Object> resultMap) throws Exception {
        block8: {
            try {
                if (!(content instanceof String)) {
                    log.error((Object)"Cannot parse non-string mail body");
                    return;
                }
                String toParse = (String)content;
                toParse = toParse.replaceAll("(\n|\r)", " ");
                log.debug((Object)("Trying to parse " + content));
                Matcher matcherEnglish = ENGLISH_HEADER_PATTERN.matcher(toParse);
                Matcher matcherFrench = HEADER_PATTERN.matcher(toParse);
                if (matcherEnglish.matches() && !matcherFrench.matches()) {
                    ParseMailBody.parseEnglishBody(matcherEnglish, resultMap);
                    break block8;
                }
                if (!matcherEnglish.matches() && matcherFrench.matches()) {
                    ParseMailBody.parseFrenchBody(matcherFrench, resultMap);
                    break block8;
                }
                if (matcherEnglish.matches() && matcherFrench.matches()) {
                    int startMatcherFrench;
                    int startMatcherEnglish = matcherEnglish.start(GROUP_TO_FIND_INDEX);
                    if (startMatcherEnglish < (startMatcherFrench = matcherFrench.start(GROUP_TO_FIND_INDEX))) {
                        ParseMailBody.parseEnglishBody(matcherEnglish, resultMap);
                    } else {
                        ParseMailBody.parseFrenchBody(matcherEnglish, resultMap);
                    }
                    break block8;
                }
                throw new IllegalArgumentException("Content cannot be matched : " + toParse);
            }
            catch (Exception e) {
                log.error((Object)"Cannot parse mail body", (Throwable)e);
            }
        }
    }

    public static Contacts parseContacts(String contacts) {
        log.debug((Object)String.format("Parsing contacts '%s'", contacts));
        if (contacts != null && contacts.length() > 0) {
            if (contacts.endsWith(TRANSFER_MARKER)) {
                contacts = contacts.substring(0, contacts.length() - TRANSFER_MARKER.length());
            }
            String[] split = contacts.trim().split("; ");
            Contacts res = new Contacts();
            for (String contact : split) {
                Matcher m = CONTACT_PATTERN.matcher(contact);
                Contact item = new Contact();
                if (m.matches()) {
                    item.setName(m.group(1).trim());
                    item.setEmail(m.group(3).trim());
                } else if (contact.matches(EMAIL_MATCH)) {
                    item.setEmail(contact.trim());
                } else {
                    item.setName(contact.trim());
                }
                res.add(item);
            }
            return res;
        }
        return null;
    }

    protected static Contacts parseEnglishContacts(String contacts) {
        log.debug((Object)String.format("Parsing contacts '%s'", contacts));
        if (contacts != null && contacts.length() > 0) {
            String[] split = contacts.trim().split("; ");
            Contacts res = new Contacts();
            for (String contact : split) {
                Matcher m = THUNDERBIDRD_ENGLISH_CONTACT_PATTERN.matcher(contact);
                Contact item = new Contact();
                if (!m.matches()) continue;
                if (log.isDebugEnabled()) {
                    for (int i = 1; i < m.groupCount() + 1; ++i) {
                        log.debug((Object)(i + ": " + m.group(i)));
                    }
                }
                item.setName(m.group(1).trim());
                item.setEmail(m.group(2).trim());
                res.add(item);
            }
            return res;
        }
        return null;
    }

    public static Calendar parseEnglishDate(String dateString) {
        try {
            log.debug((Object)String.format("Parsing date '%s'", dateString));
            SimpleDateFormat sdf = new SimpleDateFormat(ENGLISH_DATE_FORMAT, Locale.ENGLISH);
            Date date = sdf.parse(dateString.trim());
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return cal;
        }
        catch (ParseException e) {
            log.error((Object)("Parsing date failed : " + dateString), (Throwable)e);
            return null;
        }
    }

    public static Calendar parseDate(String dateString) {
        try {
            log.debug((Object)String.format("Parsing date '%s'", dateString));
            SimpleDateFormat sdf = new SimpleDateFormat(FRENCH_DATE_FORMAT, Locale.FRENCH);
            Date date = sdf.parse(dateString.trim());
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return cal;
        }
        catch (ParseException e) {
            log.error((Object)("Parsing date failed : " + dateString), (Throwable)e);
            return null;
        }
    }

    public void reset(ExecutionContext context) throws Exception {
    }
}

