/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.caselink;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.nuxeo.cm.caselink.CaseLink;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.cases.HasParticipants;
import org.nuxeo.cm.exception.CaseManagementRuntimeException;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.model.PropertyException;

public class CaseLinkImpl
implements CaseLink {
    private static final long serialVersionUID = -94563234903621891L;
    protected HasParticipants recipientAdapter;
    protected DocumentModel document;

    public CaseLinkImpl(DocumentModel doc, HasParticipants recipientAdapted) {
        this.document = doc;
        this.recipientAdapter = recipientAdapted;
    }

    @Override
    public String getComment() {
        return (String)this.getPropertyValue("cslk:comment");
    }

    protected <T> T getPropertyValue(String value) {
        try {
            return (T)this.document.getPropertyValue(value);
        }
        catch (PropertyException e) {
            throw new CaseManagementRuntimeException(e);
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException(e);
        }
    }

    protected Date getDatePropertyValue(String value) {
        try {
            Calendar cal = (Calendar)this.document.getPropertyValue(value);
            if (cal != null) {
                return cal.getTime();
            }
        }
        catch (PropertyException e) {
            throw new CaseManagementRuntimeException(e);
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException(e);
        }
        return null;
    }

    @Override
    public Date getDate() {
        return this.getDatePropertyValue("cslk:date");
    }

    @Override
    public Case getCase(CoreSession session) {
        Case envelope;
        try {
            String envelopeDocumentId = (String)((Object)this.document.getPropertyValue("cslk:caseDocumentId"));
            DocumentModel mailDocument = session.getDocument((DocumentRef)new IdRef(envelopeDocumentId));
            envelope = (Case)mailDocument.getAdapter(Case.class);
        }
        catch (PropertyException e) {
            throw new CaseManagementRuntimeException(e);
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException(e);
        }
        return envelope;
    }

    @Override
    public String getId() {
        return this.document.getId();
    }

    @Override
    public String getSender() {
        return (String)this.getPropertyValue("cslk:sender");
    }

    @Override
    public String getSubject() {
        return (String)this.getPropertyValue("dc:title");
    }

    @Override
    public String getSenderMailboxId() {
        return (String)this.getPropertyValue("cslk:senderMailboxId");
    }

    @Override
    public Date getSentDate() {
        return this.getDatePropertyValue("cslkt:sentDate");
    }

    @Override
    public String getType() {
        return (String)this.getPropertyValue("cslk:type");
    }

    @Override
    public boolean isRead() {
        return (Boolean)this.getPropertyValue("cslk:isRead");
    }

    @Override
    public void save(CoreSession session) {
        try {
            session.saveDocument(this.document);
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException(e);
        }
    }

    @Override
    public DocumentModel getDocument() {
        return this.document;
    }

    @Override
    public boolean isDraft() {
        return (Boolean)this.getPropertyValue("cslk:draft");
    }

    @Override
    public void addInitialExternalParticipants(Map<String, List<String>> recipients) {
        this.recipientAdapter.addInitialExternalParticipants(recipients);
    }

    @Override
    public void addInitialInternalParticipants(Map<String, List<String>> recipients) {
        this.recipientAdapter.addInitialInternalParticipants(recipients);
    }

    @Override
    public void addParticipants(Map<String, List<String>> recipients) {
        this.recipientAdapter.addParticipants(recipients);
    }

    @Override
    public Map<String, List<String>> getAllParticipants() {
        return this.recipientAdapter.getAllParticipants();
    }

    @Override
    public Map<String, List<String>> getInitialExternalParticipants() {
        return this.recipientAdapter.getInitialExternalParticipants();
    }

    @Override
    public Map<String, List<String>> getInitialInternalParticipants() {
        return this.recipientAdapter.getInitialInternalParticipants();
    }

    @Override
    public void setActionnable(boolean actionnable) {
        try {
            this.document.setPropertyValue("cslk:isActionable", (Serializable)Boolean.valueOf(actionnable));
        }
        catch (PropertyException e) {
            throw new RuntimeException(e);
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isActionnable() {
        return (Boolean)this.getPropertyValue("cslk:isActionable");
    }
}

