/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.cases;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class CaseTreeHelper {
    public static final String TITLE_PROPERTY_NAME = "dc:title";
    public static final String DELETED_STATE = "deleted";
    private static final Lock lock = new ReentrantLock();

    public static DocumentModel getOrCreateDateTreeFolder(CoreSession session, DocumentModel root, Date date, String folderType) throws ClientException {
        String subPath = new SimpleDateFormat("yyyy/MM/dd").format(date);
        return CaseTreeHelper.getOrCreatePath(session, root, subPath, folderType);
    }

    public static DocumentModel getOrCreatePath(CoreSession session, DocumentModel root, String subPath, String folderType) throws ClientException {
        String[] pathSplit = subPath.split("/");
        String parentPath = root.getPathAsString();
        DocumentModel child = root;
        for (String id : pathSplit) {
            child = CaseTreeHelper.getOrCreate(session, parentPath, id, folderType);
            parentPath = child.getPathAsString();
        }
        return child;
    }

    public static synchronized DocumentModel getOrCreate(CoreSession session, String rootPath, String id, String folderType) throws ClientException {
        DocumentModel existing;
        String path = String.format("%s/%s", rootPath, id);
        PathRef pathRef = new PathRef(path);
        boolean exists = session.exists((DocumentRef)pathRef);
        if (exists && !DELETED_STATE.equals((existing = session.getDocument((DocumentRef)pathRef)).getCurrentLifeCycleState())) {
            return existing;
        }
        DocumentModel newDocument = session.createDocumentModel(rootPath, IdUtils.generateId((String)id), folderType);
        newDocument.setPropertyValue(TITLE_PROPERTY_NAME, (Serializable)((Object)id));
        newDocument = session.createDocument(newDocument);
        return newDocument;
    }

    public static final DocumentModel getOrCreateTxDateTreeFolder(CoreSession session, DocumentModel root, Date date, String folderType) throws ClientException {
        String subPath = new SimpleDateFormat("yyyy/MM/dd").format(date);
        return CaseTreeHelper.getOrCreateTxPath(session, root, subPath, folderType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DocumentModel getOrCreateTxPath(CoreSession session, DocumentModel rootDocument, String subPath, String folderType) throws ClientException {
        lock.lock();
        try {
            DocumentModel documentModel;
            TransactionHelper.startTransaction();
            try {
                UnrestrictedRootTreeCreator rootTreeCreator = new UnrestrictedRootTreeCreator(session, rootDocument, subPath, folderType);
                rootTreeCreator.runUnrestricted();
                documentModel = rootTreeCreator.getChild();
            }
            catch (Throwable throwable) {
                TransactionHelper.commitOrRollbackTransaction();
                throw throwable;
            }
            TransactionHelper.commitOrRollbackTransaction();
            return documentModel;
        }
        finally {
            lock.unlock();
        }
    }

    static class UnrestrictedRootTreeCreator
    extends UnrestrictedSessionRunner {
        String path;
        String subPath;
        String id;
        String folderType;
        DocumentModel rootDoc;
        DocumentModel child;

        protected UnrestrictedRootTreeCreator(CoreSession session, DocumentModel rootDoc, String subPath, String folderType) {
            super(session);
            this.subPath = subPath;
            this.folderType = folderType;
            this.rootDoc = rootDoc;
        }

        public void run() throws ClientException {
            String[] pathSplit = this.subPath.split("/");
            String parentPath = this.rootDoc.getPathAsString();
            this.child = this.rootDoc;
            for (String id : pathSplit) {
                this.child = CaseTreeHelper.getOrCreate(this.session, parentPath, id, this.folderType);
                parentPath = this.child.getPathAsString();
            }
        }

        public DocumentModel getChild() {
            return this.child;
        }
    }
}

