/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.contact;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.cm.mailbox.Mailbox;

public class Contact
implements Serializable,
Comparable<Contact> {
    private static final CONTACT_FIELD[] FIELDS_FOR_FULLTEXT_INDEXING = new CONTACT_FIELD[]{CONTACT_FIELD.name, CONTACT_FIELD.email, CONTACT_FIELD.surname, CONTACT_FIELD.service, CONTACT_FIELD.mailboxId};
    private static final long serialVersionUID = 1L;
    protected String name;
    protected String email;
    protected String surname;
    protected String service;
    protected String mailboxId;

    public Contact() {
    }

    public Contact(Map<? extends String, ? extends Serializable> m) {
        if (m != null) {
            this.name = (String)((Object)m.get(CONTACT_FIELD.name.name()));
            this.email = (String)((Object)m.get(CONTACT_FIELD.email.name()));
            this.surname = (String)((Object)m.get(CONTACT_FIELD.surname.name()));
            this.service = (String)((Object)m.get(CONTACT_FIELD.service.name()));
            this.mailboxId = (String)((Object)m.get(CONTACT_FIELD.mailboxId.name()));
        }
    }

    public String asStringForIndexing() {
        return this.asStringFor(FIELDS_FOR_FULLTEXT_INDEXING);
    }

    private String asStringFor(CONTACT_FIELD[] fields) {
        StringBuilder sb = new StringBuilder();
        boolean empty = true;
        HashMap<String, Serializable> map = this.getContactMap();
        for (CONTACT_FIELD field : fields) {
            Serializable v = (Serializable)map.get(field.name());
            if (v == null) continue;
            if (!empty) {
                sb.append(" ");
            }
            empty = false;
            sb.append(v);
        }
        return empty ? null : sb.toString();
    }

    public HashMap<String, Serializable> getContactMap() {
        HashMap<String, Serializable> m = new HashMap<String, Serializable>();
        if (this.name != null) {
            m.put(CONTACT_FIELD.name.name(), (Serializable)((Object)this.name));
        }
        if (this.email != null) {
            m.put(CONTACT_FIELD.email.name(), (Serializable)((Object)this.email));
        }
        if (this.surname != null) {
            m.put(CONTACT_FIELD.surname.name(), (Serializable)((Object)this.surname));
        }
        if (this.service != null) {
            m.put(CONTACT_FIELD.service.name(), (Serializable)((Object)this.service));
        }
        if (this.mailboxId != null) {
            m.put(CONTACT_FIELD.mailboxId.name(), (Serializable)((Object)this.mailboxId));
        }
        return m;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getMailboxIdd() {
        return this.mailboxId;
    }

    public void setMailboxId(String mailboxId) {
        this.mailboxId = mailboxId;
    }

    public String toString() {
        return this.getContactMap().toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Contact) {
            return this.compareTo((Contact)obj) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Contact other) {
        if (other == null) {
            return 1;
        }
        return this.asStringForIndexing().compareTo(other.asStringForIndexing());
    }

    public static Contact getContactForMailbox(Mailbox mailbox, String email, String service, String surname) {
        if (mailbox == null) {
            return null;
        }
        Contact contact = new Contact();
        contact.mailboxId = mailbox.getId();
        contact.name = mailbox.getTitle();
        contact.email = email;
        contact.service = service;
        contact.surname = surname;
        return contact;
    }

    public static enum CONTACT_FIELD {
        name,
        email,
        surname,
        service,
        mailboxId;

    }
}

