/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.mail.actionpipe.parser;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.contact.Contact;
import org.nuxeo.cm.contact.Contacts;
import org.nuxeo.cm.mail.actionpipe.MailActionPipeConstants;
import org.nuxeo.cm.mail.actionpipe.parser.MailBodyParser;

public class DefaultFrenchMailParser
implements MailBodyParser,
MailActionPipeConstants {
    public static final Log log = LogFactory.getLog(DefaultFrenchMailParser.class);
    private static final String FRENCH_DATE_FORMAT = "EEEE dd MMM yyyy HH:mm";
    public static final String EMAIL_MATCH = "^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}$";
    public static final Pattern CONTACT_PATTERN = Pattern.compile("(.*)(\\[mailto:)(.*?)(\\])(.*)");
    public static final Pattern FRENCH_HEADER_PATTERN = Pattern.compile("(.*?)(De :)(.*?)(Envoy\u00e9 :)((.*?)(\u00c0 :))?((.*?)(Cc :))?(.*?)(Objet :)(.*?)", 32);
    public static final String TRANSFER_MARKER = " > ";

    @Override
    public Pattern getHeaderPattern() {
        return FRENCH_HEADER_PATTERN;
    }

    @Override
    public boolean parse(Matcher m, Map<String, Object> resultMap) {
        for (int i = 1; i < m.groupCount() + 1; ++i) {
            log.debug((Object)(i + ": " + m.group(i)));
        }
        Contacts origSenders = DefaultFrenchMailParser.parseContacts(m.group(3));
        if (origSenders != null && !origSenders.isEmpty()) {
            String origSenderName = ((Contact)origSenders.get(0)).getName();
            resultMap.put("originalSenderName", origSenderName);
        }
        resultMap.put("originalSenders", origSenders);
        if (m.group(6) != null) {
            resultMap.put("originalReceptionDate", DefaultFrenchMailParser.parseDate(m.group(6)));
            if (m.group(8) != null) {
                resultMap.put("originalToRecipients", DefaultFrenchMailParser.parseContacts(m.group(9)));
                resultMap.put("originalCcRecipients", DefaultFrenchMailParser.parseContacts(m.group(11)));
            } else {
                resultMap.put("originalToRecipients", DefaultFrenchMailParser.parseContacts(m.group(11)));
            }
        } else {
            resultMap.put("originalReceptionDate", DefaultFrenchMailParser.parseDate(m.group(11)));
        }
        return true;
    }

    public static Contacts parseContacts(String contacts) {
        log.debug((Object)String.format("Parsing contacts '%s'", contacts));
        if (contacts != null && contacts.length() > 0) {
            if (contacts.endsWith(TRANSFER_MARKER)) {
                contacts = contacts.substring(0, contacts.length() - TRANSFER_MARKER.length());
            }
            String[] split = contacts.trim().split("; ");
            Contacts res = new Contacts();
            for (String contact : split) {
                Matcher m = CONTACT_PATTERN.matcher(contact);
                Contact item = new Contact();
                if (m.matches()) {
                    item.setName(m.group(1).trim());
                    item.setEmail(m.group(3).trim());
                } else if (contact.matches(EMAIL_MATCH)) {
                    item.setEmail(contact.trim());
                } else {
                    item.setName(contact.trim());
                }
                res.add(item);
            }
            return res;
        }
        return null;
    }

    public static Calendar parseDate(String dateString) {
        try {
            log.debug((Object)String.format("Parsing date '%s'", dateString));
            SimpleDateFormat sdf = new SimpleDateFormat(FRENCH_DATE_FORMAT, Locale.FRENCH);
            Date date = sdf.parse(dateString.trim());
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return cal;
        }
        catch (ParseException e) {
            log.error((Object)("Parsing date failed : " + dateString), (Throwable)e);
            return null;
        }
    }
}

