/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.mail.actionpipe.parser;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.cm.contact.Contact;
import org.nuxeo.cm.contact.Contacts;
import org.nuxeo.cm.mail.actionpipe.parser.DefaultEnglishMailParser;

public class GmailMailParser
extends DefaultEnglishMailParser {
    public static final Pattern GMAIL_ENGLISH_HEADER_PATTERN = Pattern.compile("(.*?)Forwarded message(.*?)(From\\w*:)([^\r\n]+)[\r\n\\s]+(Date\\w*:)([^\r\n]+)[\r\n\\s]+(Subject\\w*:)([^\r\n]+)[\r\n\\s]+(To\\w*:)([^\r\n]+)[\r\n\\s]+((Cc:)([^\r\n]+))?[\r\n\\s]+.*", 32);
    public static final String GMAIL_DATE_FORMAT = "yyyy/MM/d";

    @Override
    public Pattern getHeaderPattern() {
        return GMAIL_ENGLISH_HEADER_PATTERN;
    }

    @Override
    protected DateFormat getDateFormat() {
        return new SimpleDateFormat(GMAIL_DATE_FORMAT, Locale.ENGLISH);
    }

    @Override
    public boolean parse(Matcher m, Map<String, Object> resultMap) {
        Contacts origSenders;
        if (log.isDebugEnabled()) {
            for (int i = 1; i < m.groupCount() + 1; ++i) {
                log.debug((Object)(i + ": " + m.group(i)));
            }
        }
        if ((origSenders = this.parseContacts(m.group(4))) != null && !origSenders.isEmpty()) {
            String origSenderName = ((Contact)origSenders.get(0)).getName();
            resultMap.put("originalSenderName", origSenderName);
        }
        resultMap.put("originalSenders", origSenders);
        if (m.group(6) != null) {
            resultMap.put("originalReceptionDate", this.parseDate(m.group(6)));
        }
        if (m.group(10) != null) {
            resultMap.put("originalToRecipients", this.parseContacts(m.group(10)));
        }
        Contacts ccContacts = new Contacts();
        if (m.group(13) != null) {
            ccContacts = this.parseContacts(m.group(13));
        }
        resultMap.put("originalCcRecipients", ccContacts);
        return true;
    }
}

