/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.operation;

import java.io.Serializable;
import java.util.ArrayList;
import org.nuxeo.cm.caselink.CaseLink;
import org.nuxeo.cm.service.CaseManagementDocumentTypeService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Case.Management.CreateCaseLink", category="CaseManagement", label="Case Link creation", description="Create a CaseLink to be used latter in the chain.")
public class CreateCaseLinkOperation {
    public static final String ID = "Case.Management.CreateCaseLink";
    @Context
    OperationContext context;
    private CaseManagementDocumentTypeService correspDocumentTypeService;

    @OperationMethod
    public DocumentModelList createCaseLink(DocumentModelList docs) {
        CoreSession session = this.context.getCoreSession();
        ArrayList<CaseLink> links = new ArrayList<CaseLink>();
        try {
            for (DocumentModel doc : docs) {
                DocumentModel model = session.createDocumentModel(this.getCaseManagementDocumentTypeService().getCaseLinkType());
                model.setPropertyValue("cslk:caseDocumentId", (Serializable)((Object)doc.getId()));
                CaseLink cl = (CaseLink)model.getAdapter(CaseLink.class);
                links.add(cl);
            }
            this.context.put("operation.case.links.key", links);
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
        return docs;
    }

    @OperationMethod
    public DocumentModel createCaseLink(DocumentModel doc) {
        DocumentModelListImpl list = new DocumentModelListImpl();
        list.add((Object)doc);
        return (DocumentModel)this.createCaseLink((DocumentModelList)list).get(0);
    }

    private CaseManagementDocumentTypeService getCaseManagementDocumentTypeService() throws ClientException {
        if (this.correspDocumentTypeService == null) {
            try {
                this.correspDocumentTypeService = (CaseManagementDocumentTypeService)Framework.getService(CaseManagementDocumentTypeService.class);
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
        }
        return this.correspDocumentTypeService;
    }
}

