/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.mailbox;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.exception.CaseManagementException;
import org.nuxeo.cm.exception.CaseManagementRuntimeException;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.mailbox.MailboxConstants;
import org.nuxeo.cm.mailbox.MailingList;
import org.nuxeo.cm.mailbox.MailingListImpl;
import org.nuxeo.cm.mailbox.ParticipantsList;
import org.nuxeo.cm.service.synchronization.MailboxSynchronizationConstants;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Type;

public class MailboxImpl
implements Mailbox {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(Mailbox.class);
    protected final DocumentModel doc;

    public MailboxImpl(DocumentModel doc) {
        this.doc = doc;
    }

    @Override
    public DocumentModel getDocument() {
        return this.doc;
    }

    protected String getStringProperty(String property) {
        try {
            return (String)((Object)this.doc.getPropertyValue(property));
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected List<String> getStringListProperty(String property) {
        try {
            List<String> res = null;
            Serializable propValue = this.doc.getPropertyValue(property);
            if (propValue instanceof List) {
                res = (List<String>)((Object)propValue);
            } else if (propValue instanceof String[]) {
                res = Arrays.asList((String[])propValue);
            } else if (propValue != null) {
                throw new ClientRuntimeException(String.format("Unexpected non-list value for prop %s: %s", property, propValue));
            }
            return res;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected Calendar getDateProperty(String property) {
        try {
            return (Calendar)this.doc.getPropertyValue(property);
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException(e);
        }
    }

    protected Integer getIntegerProperty(String property) {
        try {
            Serializable value = this.doc.getPropertyValue(property);
            if (value instanceof Long) {
                return Integer.valueOf(((Long)value).toString());
            }
            return null;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected void setPropertyValue(String property, Serializable value) {
        try {
            this.doc.setPropertyValue(property, value);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public MailingList getMailingListTemplate() {
        try {
            Type type2;
            Object value = null;
            Property prop = this.doc.getProperty("mlbx:mailinglists");
            Field field = prop.getField();
            if (field != null && (type2 = field.getType()).isListType()) {
                Type itemType = ((ListType)type2).getFieldType();
                value = itemType.newInstance();
            }
            if (!(value instanceof Map)) {
                throw new ClientRuntimeException("Cannot get default template for mailing list");
            }
            Map map = (Map)value;
            return new MailingListImpl(map);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public void addMailingList(MailingList ml) {
        try {
            ArrayList<Map<String, Serializable>> mls = new ArrayList<Map<String, Serializable>>();
            List mailinglists = (List)((Object)this.doc.getPropertyValue("mlbx:mailinglists"));
            if (mailinglists != null) {
                mls.addAll(mailinglists);
            }
            mls.add(ml.getMap());
            this.setPropertyValue("mlbx:mailinglists", mls);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public List<String> getUsers() {
        return this.getStringListProperty("mlbx:users");
    }

    @Override
    public String getDescription() {
        return this.getStringProperty("dc:description");
    }

    @Override
    public List<String> getFavorites() throws CaseManagementException {
        return this.getStringListProperty("mlbx:favorites");
    }

    @Override
    public List<String> getGroups() {
        return this.getStringListProperty("mlbx:groups");
    }

    @Override
    public String getId() {
        return this.getStringProperty("mlbx:mailbox_id");
    }

    @Override
    public void setId(String id) {
        this.setPropertyValue("mlbx:mailbox_id", (Serializable)((Object)id));
    }

    @Override
    public List<String> getMailingListIds() {
        ArrayList<String> mlids = new ArrayList<String>();
        List<MailingList> mls = this.getMailingLists();
        if (mls != null) {
            for (MailingList ml : mls) {
                mlids.add(ml.getId());
            }
        }
        return mlids;
    }

    @Override
    public List<MailingList> getMailingLists() {
        try {
            ArrayList<MailingList> mls = new ArrayList<MailingList>();
            List mailinglists = (List)((Object)this.doc.getPropertyValue("mlbx:mailinglists"));
            if (mailinglists != null) {
                for (Map mailinglist : mailinglists) {
                    mls.add(new MailingListImpl(mailinglist));
                }
            }
            return mls;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public Mailbox updateMailingList(MailingList currentMailingList) {
        List mailinglists;
        try {
            mailinglists = (List)((Object)this.doc.getPropertyValue("mlbx:mailinglists"));
        }
        catch (PropertyException e) {
            throw new RuntimeException(e);
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
        for (Map map : mailinglists) {
            String mlid = (String)map.get("mlid");
            if (!currentMailingList.getId().equals(mlid)) continue;
            map.put("title", currentMailingList.getTitle());
            map.put("description", currentMailingList.getDescription());
            map.put("mailbox_ids", (Serializable)((Object)currentMailingList.getMailboxIds()));
        }
        try {
            this.doc.setPropertyValue("mlbx:mailinglists", (Serializable)((Object)mailinglists));
        }
        catch (PropertyException e) {
            throw new RuntimeException(e);
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public List<String> getNotifiedUsers() {
        return this.getStringListProperty("mlbx:notified_users");
    }

    @Override
    public String getOwner() {
        return this.getStringProperty("mlbx:owner");
    }

    @Override
    public List<String> getProfiles() {
        return this.getStringListProperty("mlbx:profiles");
    }

    @Override
    public String getTitle() {
        return this.getStringProperty("dc:title");
    }

    @Override
    public String getType() {
        return this.getStringProperty("mlbx:type");
    }

    @Override
    public List<String> getAllUsers() {
        String owner;
        ArrayList<String> delegates = new ArrayList<String>();
        List<String> users = this.getUsers();
        if (users != null) {
            delegates.addAll(users);
        }
        if ((owner = this.getOwner()) != null && !delegates.contains(owner)) {
            delegates.add(0, owner);
        }
        return delegates;
    }

    @Override
    public boolean hasProfile(String profile) {
        List<String> profiles = this.getProfiles();
        return profiles != null && profiles.contains(profile);
    }

    @Override
    public void removeMailingList(String mailingListId) {
        try {
            ArrayList<Map> mls = new ArrayList<Map>();
            List mailinglists = (List)((Object)this.doc.getPropertyValue("mlbx:mailinglists"));
            if (mailinglists != null) {
                for (Map ml : mailinglists) {
                    if (mailingListId.equals(ml.get("mlid"))) continue;
                    mls.add(ml);
                }
            }
            this.setPropertyValue("mlbx:mailinglists", mls);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public void setUsers(List<String> users) {
        ArrayList<String> serializableUsers = new ArrayList<String>();
        if (users != null) {
            serializableUsers.addAll(users);
        }
        this.setPropertyValue("mlbx:users", serializableUsers);
    }

    @Override
    public void setDescription(String description) {
        this.setPropertyValue("dc:description", (Serializable)((Object)description));
    }

    @Override
    public void setFavorites(List<String> favorites) throws CaseManagementException {
        ArrayList<String> serializableFavorites = new ArrayList<String>();
        if (favorites != null) {
            serializableFavorites.addAll(favorites);
        }
        this.setPropertyValue("mlbx:favorites", serializableFavorites);
    }

    @Override
    public void setGroups(List<String> groups) {
        ArrayList<String> serializableGroups = new ArrayList<String>();
        if (groups != null) {
            serializableGroups.addAll(groups);
        }
        this.setPropertyValue("mlbx:groups", serializableGroups);
    }

    @Override
    public void setNotifiedUsers(List<String> users) {
        ArrayList<String> serializableUsers = new ArrayList<String>();
        if (users != null) {
            serializableUsers.addAll(users);
        }
        this.setPropertyValue("mlbx:notified_users", serializableUsers);
    }

    @Override
    public void setOwner(String owner) {
        this.setPropertyValue("mlbx:owner", (Serializable)((Object)owner));
    }

    @Override
    public void setProfiles(List<String> profiles) {
        ArrayList<String> serializableProfiles = new ArrayList<String>();
        if (profiles != null) {
            serializableProfiles.addAll(profiles);
        }
        this.setPropertyValue("mlbx:profiles", serializableProfiles);
    }

    @Override
    public void setTitle(String title) {
        this.setPropertyValue("dc:title", (Serializable)((Object)title));
    }

    @Override
    public void setType(String type2) {
        this.setPropertyValue("mlbx:type", (Serializable)((Object)type2));
    }

    @Override
    public void setConfidentiality(Integer confidentiality) {
        this.setPropertyValue("mlbx:defaultconfidentiality", confidentiality);
    }

    @Override
    public Integer getConfidentiality() {
        return this.getIntegerProperty("mlbx:defaultconfidentiality");
    }

    @Override
    public int compareTo(Mailbox other) {
        if (this.getType().equals(other.getType())) {
            return this.getTitle().compareTo(other.getTitle());
        }
        if (MailboxConstants.type.personal.name().equals(this.getType())) {
            return -1;
        }
        return 1;
    }

    @Override
    public void save(CoreSession session) {
        try {
            session.saveDocument(this.doc);
            session.save();
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException(e);
        }
    }

    @Override
    public String getParentId(CoreSession session) {
        try {
            DocumentModel parent;
            Mailbox parentMailbox;
            if (session.hasPermission(this.doc.getParentRef(), "Read") && (parentMailbox = (Mailbox)(parent = session.getDocument(this.doc.getParentRef())).getAdapter(Mailbox.class)) != null) {
                return parentMailbox.getId();
            }
        }
        catch (ClientException e) {
            log.error((Object)"Unable to retrieve parent mailbox id", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<String> getChildrenIds(CoreSession session) {
        ArrayList<String> res = new ArrayList<String>();
        try {
            DocumentModelList children;
            if (session.hasPermission(this.doc.getRef(), "ReadChildren") && (children = session.getChildren(this.doc.getRef())) != null) {
                for (DocumentModel child : children) {
                    Mailbox childMailbox = (Mailbox)child.getAdapter(Mailbox.class);
                    if (childMailbox == null) continue;
                    res.add(childMailbox.getId());
                }
            }
        }
        catch (ClientException e) {
            log.error((Object)"Unable to retrieve child mailbox ids", (Throwable)e);
        }
        return res;
    }

    @Override
    public List<String> getAllUsersAndGroups() {
        List<String> groups;
        ArrayList<String> total = new ArrayList<String>();
        List<String> users = this.getAllUsers();
        if (users != null) {
            total.addAll(users);
        }
        if ((groups = this.getGroups()) != null) {
            total.addAll(groups);
        }
        return total;
    }

    @Override
    public String getAffiliatedMailboxId() {
        return this.getStringProperty("mlbx:affiliated_mailbox_id");
    }

    @Override
    public void setAffiliatedMailboxId(String mbid) {
        this.setPropertyValue("mlbx:affiliated_mailbox_id", (Serializable)((Object)mbid));
    }

    @Override
    public String getSynchronizeState() {
        return this.getStringProperty("mlbx:synchronizedState");
    }

    @Override
    public void setSynchronizeState(String state) {
        this.setPropertyValue("mlbx:synchronizedState", (Serializable)((Object)state));
    }

    @Override
    public Boolean isSynchronized() {
        if (MailboxSynchronizationConstants.synchronisedState.synchronised.toString().equals(this.getSynchronizeState())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public String getSynchronizerId() {
        return this.getStringProperty("mlbx:synchronizerId");
    }

    @Override
    public void setSynchronizerId(String synchronizerId) {
        this.setPropertyValue("mlbx:synchronizerId", (Serializable)((Object)synchronizerId));
    }

    @Override
    public Calendar getLastSyncUpdate() {
        return this.getDateProperty("mlbx:lastSyncUpdate");
    }

    @Override
    public void setLastSyncUpdate(Calendar now) {
        this.setPropertyValue("mlbx:lastSyncUpdate", now);
    }

    @Override
    public String getOrigin() {
        return this.getStringProperty("mlbx:origin");
    }

    @Override
    public void setOrigin(String origin) {
        this.setPropertyValue("mlbx:origin", (Serializable)((Object)origin));
    }

    @Override
    public List<String> getParticipantListIds() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ParticipantsList> getParticipantLists() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ParticipantsList getParticipantListTemplate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addParticipantList(ParticipantsList mailinglist) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeParticipantList(String mailinglistId) {
        throw new UnsupportedOperationException();
    }
}

