/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.caselink;

import java.io.Serializable;
import java.util.HashMap;
import org.nuxeo.cm.caselink.ActionableCaseLink;
import org.nuxeo.cm.caselink.CaseLink;
import org.nuxeo.cm.caselink.CaseLinkImpl;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.cases.HasParticipants;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.platform.routing.api.ActionableObject;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteStep;
import org.nuxeo.ecm.platform.routing.api.helper.ActionableValidator;

public class ActionableCaseLinkImpl
extends CaseLinkImpl
implements ActionableCaseLink {
    private static final long serialVersionUID = 1L;

    public ActionableCaseLinkImpl(DocumentModel doc, HasParticipants recipientAdapted) {
        super(doc, recipientAdapted);
    }

    @Override
    public String getTaskType() {
        return (String)this.getPropertyValue("acslk:itaskType");
    }

    @Override
    public void validate(CoreSession session) {
        this.setDone(session);
        try {
            new UnrestrictedSessionRunner(session){

                public void run() throws ClientException {
                    HashMap<String, ActionableCaseLinkImpl> map = new HashMap<String, ActionableCaseLinkImpl>();
                    map.put("operation.case.link.key", ActionableCaseLinkImpl.this);
                    ActionableValidator validator = new ActionableValidator((ActionableObject)ActionableCaseLinkImpl.this, this.session, map);
                    validator.validate();
                }
            }.runUnrestricted();
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void refuse(CoreSession session) {
        this.setDone(session);
        try {
            new UnrestrictedSessionRunner(session){

                public void run() throws ClientException {
                    HashMap<String, ActionableCaseLinkImpl> map = new HashMap<String, ActionableCaseLinkImpl>();
                    map.put("operation.case.link.key", ActionableCaseLinkImpl.this);
                    ActionableValidator validator = new ActionableValidator((ActionableObject)ActionableCaseLinkImpl.this, this.session, map);
                    validator.refuse();
                }
            }.runUnrestricted();
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    public String getRefuseOperationChainId() {
        return (String)this.getPropertyValue("acslk:refusalOperationChainId");
    }

    public String getValidateOperationChainId() {
        return (String)this.getPropertyValue("acslk:validationOperationChainId");
    }

    public DocumentRouteStep getDocumentRouteStep(CoreSession session) {
        String stepId = (String)this.getPropertyValue("acslk:stepDocumentId");
        try {
            return (DocumentRouteStep)session.getDocument((DocumentRef)new IdRef(stepId)).getAdapter(DocumentRouteStep.class);
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    public DocumentModelList getAttachedDocuments(CoreSession session) {
        Case kase = this.getCase(session);
        DocumentModelListImpl result = new DocumentModelListImpl();
        result.add((Object)kase.getDocument());
        return result;
    }

    @Override
    public void setRefuseOperationChainId(String refuseChainId) {
        try {
            this.document.setPropertyValue("acslk:refusalOperationChainId", (Serializable)((Object)refuseChainId));
        }
        catch (PropertyException e) {
            throw new RuntimeException(e);
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setValidateOperationChainId(String validateChainId) {
        try {
            this.document.setPropertyValue("acslk:validationOperationChainId", (Serializable)((Object)validateChainId));
        }
        catch (PropertyException e) {
            throw new RuntimeException(e);
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setStepId(String id) {
        try {
            this.document.setPropertyValue("acslk:stepDocumentId", (Serializable)((Object)id));
        }
        catch (PropertyException e) {
            throw new RuntimeException(e);
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getStepId() {
        return (String)this.getPropertyValue("acslk:stepDocumentId");
    }

    @Override
    public boolean isTodo() {
        try {
            return this.document.getCurrentLifeCycleState().equals(CaseLink.CaseLinkState.todo.name());
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isDone() {
        try {
            return this.document.getCurrentLifeCycleState().equals(CaseLink.CaseLinkState.done.name());
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setDone(CoreSession session) {
        try {
            session.followTransition(this.document.getRef(), CaseLink.CaseLinkTransistion.toDone.name());
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }
}

