/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.operation;

import java.util.List;
import org.nuxeo.cm.caselink.CaseLink;
import org.nuxeo.cm.service.CaseDistributionService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Case.Management.Distribution", category="CaseManagement", label="Distribute a case", description="Distribute a case according to the CaseLink found in the context.")
public class DistributionOperation {
    public static final String ID = "Case.Management.Distribution";
    @Context
    protected OperationContext context;

    public CaseDistributionService getDistributionService() {
        try {
            return (CaseDistributionService)Framework.getService(CaseDistributionService.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @OperationMethod
    public void distribute() {
        CoreSession session = this.context.getCoreSession();
        List caseLinks = (List)this.context.get((Object)"operation.case.links.key");
        for (CaseLink caseLink : caseLinks) {
            this.getDistributionService().sendCase(session, caseLink, false, caseLink.isActionnable());
        }
    }
}

