/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.web.contentbrowser;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.cm.web.context.CaseManagementContextHolderBean;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.Sorter;
import org.nuxeo.ecm.core.search.api.client.querymodel.QueryModel;
import org.nuxeo.ecm.core.search.api.client.querymodel.descriptor.QueryModelDescriptor;
import org.nuxeo.ecm.virtualnavigation.action.MultiNavTreeManager;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNode;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNodeImpl;
import org.nuxeo.ecm.webapp.tree.TreeActionsBean;
import org.nuxeo.ecm.webapp.tree.TreeManager;
import org.nuxeo.runtime.api.Framework;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="treeActions")
@Install(precedence=20)
public class CaseTreeActionsBean
extends TreeActionsBean {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CaseTreeActionsBean.class);
    @In(create=true)
    protected transient MultiNavTreeManager multiNavTreeManager;
    @In(create=true, required=false)
    protected transient CaseManagementContextHolderBean cmContextHolder;
    private boolean renderChildTree;
    private String treeName;
    private String docView;
    private DocumentModel rootDocument;

    public boolean getRenderChildTree() throws ClientException {
        if (!this.renderChildTree) {
            for (SupportedNavigationTrees navTree : SupportedNavigationTrees.values()) {
                if (!navTree.toString().equals(this.multiNavTreeManager.getSelectedNavigationTree())) continue;
                this.treeName = this.multiNavTreeManager.getSelectedNavigationTree();
                this.setNavigationChildTreeContext();
                return true;
            }
        }
        return false;
    }

    public void resetChildTree() {
        this.reset();
        this.treeName = null;
        this.rootDocument = null;
        this.renderChildTree = false;
        this.docView = null;
    }

    protected void setNavigationChildTreeContext() throws ClientException {
        String navTree = this.multiNavTreeManager.getSelectedNavigationTree();
        if (navTree.equals(SupportedNavigationTrees.MAILBOXES_FOLDER.toString())) {
            if (this.cmContextHolder.getCurrentCase() != null) {
                this.rootDocument = this.cmContextHolder.getCurrentCase().getDocument();
                this.docView = "cm_view";
            }
        } else if (navTree.equals(SupportedNavigationTrees.CLASSIFICATION_FOLDER.toString())) {
            this.rootDocument = this.cmContextHolder.getCurrentClassificationRoot();
            this.docView = "view_documents";
        } else if (navTree.equals(SupportedNavigationTrees.ROUTE_FOLDER.toString())) {
            this.rootDocument = this.cmContextHolder.getCurrentRouteRoot();
            this.docView = "view_documents";
        }
    }

    public List<DocumentTreeNode> getChildrenTreeRoots() throws ClientException {
        ArrayList<DocumentTreeNodeImpl> currentTree;
        if (this.treeInvalidator.needsInvalidation()) {
            this.reset();
            this.treeInvalidator.invalidationDone();
        }
        if ((currentTree = (ArrayList<DocumentTreeNodeImpl>)this.trees.get(this.treeName)) == null) {
            currentTree = new ArrayList<DocumentTreeNodeImpl>();
            DocumentModel firstAccessibleParent = null;
            if (this.rootDocument != null) {
                firstAccessibleParent = this.rootDocument;
            }
            if (firstAccessibleParent != null) {
                Filter filter = null;
                Filter leafFilter = null;
                Sorter sorter = null;
                String pageProvider = null;
                QueryModel queryModel = null;
                QueryModel orderableQueryModel = null;
                try {
                    TreeManager treeManager = (TreeManager)Framework.getService(TreeManager.class);
                    filter = treeManager.getFilter(this.treeName);
                    leafFilter = treeManager.getLeafFilter(this.treeName);
                    sorter = treeManager.getSorter(this.treeName);
                    pageProvider = treeManager.getPageProviderName(this.treeName);
                    QueryModelDescriptor queryModelDescriptor = treeManager.getQueryModelDescriptor(this.treeName);
                    queryModel = queryModelDescriptor == null ? null : new QueryModel(queryModelDescriptor);
                    QueryModelDescriptor orderableQueryModelDescriptor = treeManager.getOrderableQueryModelDescriptor(this.treeName);
                    orderableQueryModel = orderableQueryModelDescriptor == null ? null : new QueryModel(orderableQueryModelDescriptor);
                }
                catch (Exception e) {
                    log.error((Object)"Could not fetch filter or sorter for tree ", (Throwable)e);
                }
                DocumentTreeNodeImpl treeRoot = null;
                treeRoot = pageProvider == null ? new DocumentTreeNodeImpl(this.documentManager.getSessionId(), firstAccessibleParent, filter, leafFilter, sorter, queryModel, orderableQueryModel) : new DocumentTreeNodeImpl(this.documentManager.getSessionId(), firstAccessibleParent, filter, leafFilter, sorter, pageProvider);
                currentTree.add(treeRoot);
                log.debug((Object)("Tree initialized with document: " + firstAccessibleParent.getId()));
            } else {
                log.debug((Object)"Could not initialize the navigation tree: no parent found for current document");
            }
            this.trees.put(this.treeName, currentTree);
        }
        return (List)this.trees.get(this.treeName);
    }

    public DocumentModel getRootDocument() {
        return this.rootDocument;
    }

    public String getDocView() {
        return this.docView;
    }

    protected static enum SupportedNavigationTrees {
        MAILBOXES_FOLDER,
        CLASSIFICATION_FOLDER,
        ROUTE_FOLDER;

    }
}

