/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.web.histrory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.web.invalidations.CaseManagementContextBound;
import org.nuxeo.cm.web.invalidations.CaseManagementContextBoundInstance;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.audit.api.AuditException;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.comment.LinkedDocument;
import org.nuxeo.ecm.platform.audit.web.listener.ContentHistoryActions;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModel;
import org.nuxeo.ecm.platform.ui.web.model.impl.SelectDataModelImpl;

@Name(value="cmHistoryActions")
@Scope(value=ScopeType.CONVERSATION)
@CaseManagementContextBound
public class CaseManagementHistoryActionsBean
extends CaseManagementContextBoundInstance {
    private static final long serialVersionUID = 1L;
    protected List<? extends LogEntry> logEntries;
    protected Map<Long, String> logEntriesComments;
    protected Map<Long, LinkedDocument> logEntriesLinkedDocs;
    protected List<? extends LogEntry> distributionLogEntries;
    protected Map<Long, String> distributionLogEntriesComments;
    protected Map<Long, LinkedDocument> distributionLogEntriesLinkedDocs;
    protected List<? extends LogEntry> caseDistributionLogEntries;
    @In(create=true)
    protected transient ContentHistoryActions contentHistoryActions;

    protected void resetCurrentEmailCache(DocumentModel cachedEmail, DocumentModel newEmail) throws ClientException {
        this.logEntries = null;
        this.logEntriesComments = null;
        this.logEntriesLinkedDocs = null;
        this.distributionLogEntries = null;
        this.distributionLogEntriesComments = null;
        this.distributionLogEntriesLinkedDocs = null;
        this.caseDistributionLogEntries = null;
    }

    @Factory(value="caseItemLogEntries", scope=ScopeType.EVENT)
    public List<? extends LogEntry> computeLogEntries() throws AuditException {
        if (this.logEntries == null) {
            try {
                DocumentModel currentEmail = this.getCurrentCaseItem();
                if (currentEmail != null) {
                    this.logEntries = this.contentHistoryActions.computeLogEntries(currentEmail);
                    this.logEntries = this.everyThingElseThanDistributionPostFilter(this.logEntries);
                }
            }
            catch (ClientException e) {
                throw new AuditException((Throwable)e);
            }
        }
        return this.logEntries;
    }

    @Factory(value="caseItemLogEntriesSelectModel", scope=ScopeType.EVENT)
    public SelectDataModel computeSelectDataModelLogEntries() throws ClientException {
        return new SelectDataModelImpl("cm_history", this.computeLogEntries(), null);
    }

    @Factory(value="caseItemDistributionLogEntries", scope=ScopeType.EVENT)
    public List<? extends LogEntry> computeDistributionLogEntries() throws AuditException {
        if (this.distributionLogEntries == null) {
            try {
                DocumentModel currentEmail = this.getCurrentCaseItem();
                if (currentEmail != null) {
                    this.distributionLogEntries = this.contentHistoryActions.computeLogEntries(currentEmail);
                    this.distributionLogEntries = this.distributionPostFilter(this.distributionLogEntries);
                }
            }
            catch (ClientException e) {
                throw new AuditException((Throwable)e);
            }
        }
        return this.distributionLogEntries;
    }

    @Factory(value="caseItemDistributionLogEntriesSelectModel", scope=ScopeType.EVENT)
    public SelectDataModel computeSelectModelDistributionLogEntries() throws ClientException {
        return new SelectDataModelImpl("cm_distribution_history", this.computeDistributionLogEntries(), null);
    }

    @Factory(value="caseItemDistributionLogEntries", scope=ScopeType.EVENT)
    public List<? extends LogEntry> computeCaseDistributionLogEntries() throws AuditException {
        if (this.caseDistributionLogEntries == null) {
            try {
                DocumentModel currentCaseDoc;
                Case currentCase = this.getCurrentCase();
                if (currentCase != null && (currentCaseDoc = currentCase.getDocument()) != null) {
                    this.caseDistributionLogEntries = this.contentHistoryActions.computeLogEntries(currentCaseDoc);
                    this.caseDistributionLogEntries = this.distributionPostFilter(this.caseDistributionLogEntries);
                }
            }
            catch (ClientException e) {
                throw new AuditException((Throwable)e);
            }
        }
        return this.caseDistributionLogEntries;
    }

    @Factory(value="caseDistributionLogEntriesSelectModel", scope=ScopeType.EVENT)
    public SelectDataModel computeCaseSelectModelDistributionLogEntries() throws ClientException {
        return new SelectDataModelImpl("cm_distribution_history", this.computeCaseDistributionLogEntries(), null);
    }

    @Factory(value="caseItemLogEntriesComments", scope=ScopeType.EVENT)
    public Map<Long, String> computeLogEntriesComments() throws AuditException {
        if (this.logEntriesComments == null) {
            this.computeLogEntries();
            this.postProcessComments(this.logEntries);
        }
        return this.logEntriesComments;
    }

    @Factory(value="caseItemDistributionLogEntriesComments", scope=ScopeType.EVENT)
    public Map<Long, String> computeDistributionLogEntriesComments() throws AuditException {
        if (this.distributionLogEntriesComments == null) {
            this.computeDistributionLogEntries();
            this.postDistributionProcessComments(this.distributionLogEntries);
        }
        return this.distributionLogEntriesComments;
    }

    @Factory(value="caseItemLogEntriesLinkedDocs", scope=ScopeType.EVENT)
    public Map<Long, LinkedDocument> computeLogEntrieslinkedDocs() throws AuditException {
        if (this.logEntriesLinkedDocs == null) {
            this.computeLogEntries();
            this.postProcessComments(this.logEntries);
        }
        return this.logEntriesLinkedDocs;
    }

    @Factory(value="caseItemDistibutionEntriesLogLinkedDocs", scope=ScopeType.EVENT)
    public Map<Long, LinkedDocument> computeLogDistributionEntrieslinkedDocs() throws AuditException {
        if (this.distributionLogEntriesLinkedDocs == null) {
            this.computeDistributionLogEntries();
            this.postDistributionProcessComments(this.distributionLogEntries);
        }
        return this.logEntriesLinkedDocs;
    }

    protected void postProcessComments(List<? extends LogEntry> logEntries) throws AuditException {
        this.logEntriesComments = new HashMap<Long, String>();
        this.logEntriesLinkedDocs = new HashMap<Long, LinkedDocument>();
        if (logEntries == null) {
            return;
        }
        for (LogEntry logEntry : logEntries) {
            this.logEntriesComments.put(logEntry.getId(), this.contentHistoryActions.getLogComment(logEntry));
            LinkedDocument linkedDoc = this.contentHistoryActions.getLogLinkedDocument(logEntry);
            if (linkedDoc == null) continue;
            this.logEntriesLinkedDocs.put(logEntry.getId(), linkedDoc);
        }
    }

    protected void postDistributionProcessComments(List<? extends LogEntry> logEntries) throws AuditException {
        this.distributionLogEntriesComments = new HashMap<Long, String>();
        this.distributionLogEntriesLinkedDocs = new HashMap<Long, LinkedDocument>();
        if (logEntries == null) {
            return;
        }
        for (LogEntry logEntry : logEntries) {
            String entryComment = this.contentHistoryActions.getLogComment(logEntry);
            if (entryComment != null) {
                entryComment = entryComment.replace(":", ":\n").replace(",", ",\n");
            }
            this.distributionLogEntriesComments.put(logEntry.getId(), entryComment);
            LinkedDocument linkedDoc = this.contentHistoryActions.getLogLinkedDocument(logEntry);
            if (linkedDoc == null) continue;
            this.distributionLogEntriesLinkedDocs.put(logEntry.getId(), linkedDoc);
        }
    }

    protected List<LogEntry> distributionPostFilter(List<? extends LogEntry> logEntries) throws AuditException {
        ArrayList<LogEntry> distLogEntries = new ArrayList<LogEntry>();
        if (logEntries == null) {
            return null;
        }
        for (LogEntry logEntry : logEntries) {
            if (!"DISTRIBUTION".equals(logEntry.getCategory())) continue;
            distLogEntries.add(logEntry);
        }
        return distLogEntries;
    }

    protected List<LogEntry> everyThingElseThanDistributionPostFilter(List<? extends LogEntry> logEntries) throws AuditException {
        ArrayList<LogEntry> otherLogEntries = new ArrayList<LogEntry>();
        if (logEntries == null) {
            return null;
        }
        for (LogEntry logEntry : logEntries) {
            if ("DISTRIBUTION".equals(logEntry.getCategory())) continue;
            otherLogEntries.add(logEntry);
        }
        return otherLogEntries;
    }
}

