/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.web.distribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.mailbox.MailboxHeader;
import org.nuxeo.cm.service.MailboxManagementService;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.api.Framework;

public class DistributionFunctions {
    private static final Log log = LogFactory.getLog(DistributionFunctions.class);
    public static final int NUMBER_OF_WORDS = 50;

    public static String join(Collection<Object> collection, String separator) {
        if (collection == null) {
            return null;
        }
        return StringUtils.join(collection.iterator(), (String)separator);
    }

    public static String getMailboxTitle(CoreSession session, String mailboxId) {
        MailboxHeader mailboxHeader = DistributionFunctions.getMailboxHeader(session, mailboxId);
        if (mailboxHeader != null) {
            return mailboxHeader.getTitle();
        }
        return mailboxId;
    }

    public static String getMailboxTitles(CoreSession session, List<String> mailboxIds, String separator, Boolean sorted) {
        List<MailboxHeader> mailboxes = DistributionFunctions.getMailboxHeaders(session, mailboxIds);
        if (mailboxes != null) {
            ArrayList<String> titles = new ArrayList<String>();
            for (MailboxHeader mb : mailboxes) {
                titles.add(mb.getTitle());
            }
            if (sorted.booleanValue()) {
                Collections.sort(titles);
            }
            return StringUtils.join((Object[])titles.toArray(new String[0]), (String)separator);
        }
        return null;
    }

    public static Mailbox getMailbox(DocumentModel mailboxDoc) {
        return (Mailbox)mailboxDoc.getAdapter(Mailbox.class);
    }

    public static Mailbox getMailbox(CoreSession session, String mailboxId) {
        try {
            MailboxManagementService service = (MailboxManagementService)Framework.getService(MailboxManagementService.class);
            return service.getMailbox(session, mailboxId);
        }
        catch (Exception e) {
            log.error((Object)("Failed to get mailbox: " + mailboxId), (Throwable)e);
            return null;
        }
    }

    public static MailboxHeader getMailboxHeader(CoreSession session, String mailboxId) {
        try {
            MailboxManagementService service = (MailboxManagementService)Framework.getService(MailboxManagementService.class);
            return service.getMailboxHeader(session, mailboxId);
        }
        catch (Exception e) {
            log.error((Object)("Failed to get mailbox headers: " + mailboxId), (Throwable)e);
            return null;
        }
    }

    public static List<Mailbox> getMailboxes(CoreSession session, List<String> mailboxIds) {
        try {
            MailboxManagementService service = (MailboxManagementService)Framework.getService(MailboxManagementService.class);
            return service.getMailboxes(session, mailboxIds);
        }
        catch (Exception e) {
            log.error((Object)("Failed to get mailboxes: " + mailboxIds), (Throwable)e);
            return null;
        }
    }

    public static List<MailboxHeader> getMailboxHeaders(CoreSession session, List<String> mailboxIds) {
        try {
            MailboxManagementService service = (MailboxManagementService)Framework.getService(MailboxManagementService.class);
            return service.getMailboxesHeaders(session, mailboxIds);
        }
        catch (Exception e) {
            log.error((Object)("Failed to get mailboxes headers: " + mailboxIds), (Throwable)e);
            return null;
        }
    }

    public static String formatStringForView(String summary) {
        Object[] words = summary.split(" ");
        if (words.length > 50) {
            Object[] wordsToReturn = new String[50];
            for (int i = 0; i < 50; ++i) {
                wordsToReturn[i] = words[i];
            }
            return StringUtils.join((Object[])wordsToReturn, (String)" ") + " ...";
        }
        return StringUtils.join((Object[])words, (String)" ");
    }
}

