/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.web.contentbrowser;

import java.util.ArrayList;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.virtualnavigation.action.MultiNavTreeManager;
import org.nuxeo.ecm.virtualnavigation.action.NavTreeDescriptor;
import org.nuxeo.ecm.virtualnavigation.service.NavTreeService;
import org.nuxeo.runtime.api.Framework;

@Name(value="multiNavTreeManager")
@Scope(value=ScopeType.CONVERSATION)
public class CMMultiNavTreeManager
extends MultiNavTreeManager {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected NuxeoPrincipal currentUser;
    protected List<NavTreeDescriptor> personnalNavTree;
    protected List<NavTreeDescriptor> outsideNavTree;
    protected List<NavTreeDescriptor> currentNavTree;

    @Create
    public void create() {
        this.outsideNavTree = this.getNavTree(this.currentUser.isAdministrator());
        this.personnalNavTree = this.getNavTree(true);
        this.setSelectedNavigationTree(this.currentUser.isAdministrator() ? "CONTENT_TREE" : "MAILBOXES_FOLDER");
        this.currentNavTree = this.outsideNavTree;
    }

    protected List<NavTreeDescriptor> getNavTree(boolean includeStdNav) {
        ArrayList<NavTreeDescriptor> result = new ArrayList<NavTreeDescriptor>();
        if (includeStdNav) {
            result.add(new NavTreeDescriptor("CONTENT_TREE", "label.content.tree"));
        }
        NavTreeService navTreeService = (NavTreeService)Framework.getLocalService(NavTreeService.class);
        result.addAll(navTreeService.getTreeDescriptors());
        return result;
    }

    public List<NavTreeDescriptor> getAvailableNavigationTrees() {
        return this.currentNavTree;
    }

    @Observer(value={"personnalWorkspace"})
    public void switchToPersonnal() {
        this.currentNavTree = this.personnalNavTree;
        this.setSelectedNavigationTree("CONTENT_TREE");
    }

    @Observer(value={"goHome"})
    public void switchToOutside() {
        this.currentNavTree = this.outsideNavTree;
        this.setSelectedNavigationTree(this.currentUser.isAdministrator() ? "CONTENT_TREE" : "MAILBOXES_FOLDER");
    }
}

