/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class URIUtils {
    private static final Log log = LogFactory.getLog(URIUtils.class);

    private URIUtils() {
    }

    public static String getURIQuery(Map<String, String> parameters) {
        String query = null;
        if (parameters != null) {
            try {
                ArrayList<String> items = new ArrayList<String>();
                for (Map.Entry<String, String> paramInfo : parameters.entrySet()) {
                    String key = paramInfo.getKey();
                    String value = paramInfo.getValue();
                    if (key == null) continue;
                    if (value == null) {
                        value = "";
                    }
                    items.add(String.format("%s=%s", URLEncoder.encode(key, "UTF-8"), URLEncoder.encode(value, "UTF-8")));
                }
                query = StringUtils.join(items, "&");
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)"Failed to get uri query", (Throwable)e);
            }
        }
        return query;
    }

    public static String getURIPath(String uri) {
        if (uri == null) {
            return null;
        }
        String path = uri;
        int index = uri.indexOf(63);
        if (index != -1) {
            path = uri.substring(0, index);
        }
        return path;
    }

    public static Map<String, String> getRequestParameters(String uriQuery) {
        HashMap<String, String> parameters = null;
        if (uriQuery != null && uriQuery.length() > 0) {
            try {
                String[] items = uriQuery.split("&");
                if (items != null && items.length > 0) {
                    parameters = new HashMap<String, String>();
                    for (String item : items) {
                        String[] param = item.split("=");
                        if (param == null) continue;
                        if (param.length == 2) {
                            parameters.put(URLDecoder.decode(param[0], "UTF-8"), URLDecoder.decode(param[1], "UTF-8"));
                            continue;
                        }
                        if (param.length != 1) continue;
                        parameters.put(URLDecoder.decode(param[0], "UTF-8"), null);
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)"Failed to get request parameters from uri", (Throwable)e);
            }
        }
        return parameters;
    }

    public static String addParametersToURIQuery(String uriString, Map<String, String> parameters) {
        String res = uriString;
        try {
            String uriPath = URIUtils.getURIPath(uriString);
            URI uri = URI.create(uriString);
            String query = uri.getQuery();
            Map<String, String> existingParams = URIUtils.getRequestParameters(query);
            if (existingParams == null) {
                existingParams = new HashMap<String, String>();
            }
            existingParams.putAll(parameters);
            if (existingParams != null && !existingParams.isEmpty()) {
                String newQuery = URIUtils.getURIQuery(existingParams);
                res = uriPath + '?' + newQuery;
            } else {
                res = uriPath;
            }
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"Failed to add new parameters to uri", (Throwable)e);
        }
        return res;
    }
}

